/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

class CppCharFormatter
implements CharFormatter {
    CppCharFormatter() {
    }

    public String escapeChar(int n2, boolean bl) {
        switch (n2) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (n2 < 32 || n2 > 126) {
            if (n2 > 255) {
                String string = Integer.toString(n2, 16);
                while (string.length() < 4) {
                    string = '0' + string;
                }
                return "\\u" + string;
            }
            return "\\" + Integer.toString(n2, 8);
        }
        return String.valueOf((char)n2);
    }

    public String escapeString(String string) {
        String string2 = new String();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            string2 = string2 + this.escapeChar(string.charAt(i2), false);
        }
        return string2;
    }

    public String literalChar(int n2) {
        String string = "0x" + Integer.toString(n2, 16);
        if (n2 >= 0 && n2 <= 126) {
            string = string + " /* '" + this.escapeChar(n2, true) + "' */ ";
        }
        return string;
    }

    public String literalString(String string) {
        return "\"" + this.escapeString(string) + "\"";
    }
}

