/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

import antlr.CharFormatter;
import antlr.collections.impl.IntRange;
import antlr.collections.impl.Vector;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int NIBBLE = 4;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(int n2) {
        this.bits = new long[(n2 - 1 >> 6) + 1];
    }

    public void add(int n2) {
        int n3 = BitSet.wordNumber(n2);
        if (n3 >= this.bits.length) {
            this.growToInclude(n2);
        }
        int n4 = n3;
        this.bits[n4] = this.bits[n4] | BitSet.bitMask(n2);
    }

    public BitSet and(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.andInPlace(bitSet);
        return bitSet2;
    }

    public void andInPlace(BitSet bitSet) {
        int n2;
        int n3 = Math.min(this.bits.length, bitSet.bits.length);
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            int n4 = n2;
            this.bits[n4] = this.bits[n4] & bitSet.bits[n2];
        }
        for (n2 = n3; n2 < this.bits.length; ++n2) {
            this.bits[n2] = 0L;
        }
    }

    private static final long bitMask(int n2) {
        int n3 = n2 & 0x3F;
        return 1L << n3;
    }

    public void clear() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            this.bits[i2] = 0L;
        }
    }

    public void clear(int n2) {
        int n3 = BitSet.wordNumber(n2);
        if (n3 >= this.bits.length) {
            this.growToInclude(n2);
        }
        int n4 = n3;
        this.bits[n4] = this.bits[n4] & (BitSet.bitMask(n2) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public int degree() {
        int n2 = 0;
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            long l2 = this.bits[i2];
            if (l2 == 0L) continue;
            for (int i3 = 63; i3 >= 0; --i3) {
                if ((l2 & 1L << i3) == 0L) continue;
                ++n2;
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BitSet) {
            int n2;
            BitSet bitSet = (BitSet)object;
            int n3 = n2 = Math.min(this.bits.length, bitSet.bits.length);
            while (n3-- > 0) {
                if (this.bits[n3] == bitSet.bits[n3]) continue;
                return false;
            }
            if (this.bits.length > n2) {
                n3 = this.bits.length;
                while (n3-- > n2) {
                    if (this.bits[n3] == 0L) continue;
                    return false;
                }
            } else if (bitSet.bits.length > n2) {
                n3 = bitSet.bits.length;
                while (n3-- > n2) {
                    if (bitSet.bits[n3] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Vector getRanges(int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        int n2 = nArray[0];
        int n3 = nArray[nArray.length - 1];
        if (nArray.length <= 2) {
            return null;
        }
        Vector vector = new Vector(5);
        for (int i2 = 0; i2 < nArray.length - 2; ++i2) {
            int n4 = nArray.length - 1;
            for (int i3 = i2 + 1; i3 < nArray.length; ++i3) {
                if (nArray[i3] == nArray[i3 - 1] + 1) continue;
                n4 = i3 - 1;
                break;
            }
            if (n4 - i2 <= 2) continue;
            vector.appendElement(new IntRange(nArray[i2], nArray[n4]));
        }
        return vector;
    }

    public void growToInclude(int n2) {
        int n3 = Math.max(this.bits.length << 1, this.numWordsToHold(n2));
        long[] lArray = new long[n3];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public boolean member(int n2) {
        int n3 = BitSet.wordNumber(n2);
        if (n3 >= this.bits.length) {
            return false;
        }
        return (this.bits[n3] & BitSet.bitMask(n2)) != 0L;
    }

    public boolean nil() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            if (this.bits[i2] == 0L) continue;
            return false;
        }
        return true;
    }

    public BitSet not() {
        BitSet bitSet = (BitSet)this.clone();
        bitSet.notInPlace();
        return bitSet;
    }

    public void notInPlace() {
        for (int i2 = this.bits.length - 1; i2 >= 0; --i2) {
            this.bits[i2] = this.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void notInPlace(int n2) {
        this.notInPlace(0, n2);
    }

    public void notInPlace(int n2, int n3) {
        this.growToInclude(n3);
        for (int i2 = n2; i2 <= n3; ++i2) {
            int n4;
            int n5 = n4 = BitSet.wordNumber(i2);
            this.bits[n5] = this.bits[n5] ^ BitSet.bitMask(i2);
        }
    }

    private final int numWordsToHold(int n2) {
        return (n2 >> 6) + 1;
    }

    public static BitSet of(int n2) {
        BitSet bitSet = new BitSet(n2 + 1);
        bitSet.add(n2);
        return bitSet;
    }

    public BitSet or(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.orInPlace(bitSet);
        return bitSet2;
    }

    public void orInPlace(BitSet bitSet) {
        if (bitSet.bits.length > this.bits.length) {
            this.setSize(bitSet.bits.length);
        }
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n3 = i2;
            this.bits[n3] = this.bits[n3] | bitSet.bits[i2];
        }
    }

    public void remove(int n2) {
        int n3 = BitSet.wordNumber(n2);
        if (n3 >= this.bits.length) {
            this.growToInclude(n2);
        }
        int n4 = n3;
        this.bits[n4] = this.bits[n4] & (BitSet.bitMask(n2) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int n2) {
        long[] lArray = new long[n2];
        int n3 = Math.min(n2, this.bits.length);
        System.arraycopy(this.bits, 0, lArray, 0, n3);
        this.bits = lArray;
    }

    public int size() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet bitSet) {
        if (bitSet == null || !(bitSet instanceof BitSet)) {
            return false;
        }
        return this.and(bitSet).equals(this);
    }

    public void subtractInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        for (int i2 = 0; i2 < this.bits.length && i2 < bitSet.bits.length; ++i2) {
            int n2 = i2;
            this.bits[n2] = this.bits[n2] & (bitSet.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.degree()];
        int n2 = 0;
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            nArray[n2++] = i2;
        }
        return nArray;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String string) {
        String string2 = "";
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = string2 + i2;
        }
        return string2;
    }

    public String toString(String string, CharFormatter charFormatter) {
        String string2 = "";
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = string2 + charFormatter.literalChar(i2);
        }
        return string2;
    }

    public String toString(String string, Vector vector) {
        if (vector == null) {
            return this.toString(string);
        }
        String string2 = "";
        for (int i2 = 0; i2 < this.bits.length << 6; ++i2) {
            if (!this.member(i2)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = i2 >= vector.size() ? string2 + "<bad element " + i2 + ">" : (vector.elementAt(i2) == null ? string2 + "<" + i2 + ">" : string2 + (String)vector.elementAt(i2));
        }
        return string2;
    }

    public String toStringOfHalfWords() {
        String string = new String();
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            if (i2 != 0) {
                string = string + ", ";
            }
            long l2 = this.bits[i2];
            string = string + (l2 &= 0xFFFFFFFFL) + "UL";
            string = string + ", ";
            l2 = this.bits[i2] >>> 32;
            string = string + (l2 &= 0xFFFFFFFFL) + "UL";
        }
        return string;
    }

    public String toStringOfWords() {
        String string = new String();
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            if (i2 != 0) {
                string = string + ", ";
            }
            string = string + this.bits[i2] + "L";
        }
        return string;
    }

    public String toStringWithRanges(String string, CharFormatter charFormatter) {
        String string2 = "";
        int[] nArray = this.toArray();
        if (nArray.length == 0) {
            return "";
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = 0;
            int n3 = i2 + 1;
            while (n3 < nArray.length && nArray[n3] == nArray[n3 - 1] + 1) {
                n2 = n3++;
            }
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            if (n2 - i2 >= 2) {
                string2 = string2 + charFormatter.literalChar(nArray[i2]);
                string2 = string2 + "..";
                string2 = string2 + charFormatter.literalChar(nArray[n2]);
                i2 = n2;
                continue;
            }
            string2 = string2 + charFormatter.literalChar(nArray[i2]);
        }
        return string2;
    }

    private static final int wordNumber(int n2) {
        return n2 >> 6;
    }
}

