/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1Sequence;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.BERConstructedOctetString;
import com.lowagie.bc.asn1.DEREncodable;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROctetString;
import com.lowagie.bc.asn1.DEROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1OctetString
extends DERObject {
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ASN1OctetString.getInstance(obj.getObject());
    }

    public static ASN1OctetString getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1OctetString) {
            return (ASN1OctetString)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        if (obj instanceof ASN1Sequence) {
            Vector v = new Vector();
            Enumeration e2 = ((ASN1Sequence)obj).getObjects();
            while (e2.hasMoreElements()) {
                v.addElement(e2.nextElement());
            }
            return new BERConstructedOctetString(v);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public ASN1OctetString(byte[] string) {
        this.string = string;
    }

    public ASN1OctetString(DEREncodable obj) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(obj);
            dOut.close();
            this.string = bOut.toByteArray();
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Error processing object : " + e2.toString());
        }
    }

    public byte[] getOctets() {
        return this.string;
    }

    public int hashCode() {
        byte[] b2 = this.getOctets();
        int value = 0;
        int i2 = 0;
        while (i2 != b2.length) {
            value ^= (b2[i2] & 0xFF) << i2 % 4;
            ++i2;
        }
        return value;
    }

    public boolean equals(Object o2) {
        byte[] b2;
        if (o2 == null || !(o2 instanceof DEROctetString)) {
            return false;
        }
        DEROctetString other = (DEROctetString)o2;
        byte[] b1 = other.getOctets();
        if (b1.length != (b2 = this.getOctets()).length) {
            return false;
        }
        int i2 = 0;
        while (i2 != b1.length) {
            if (b1[i2] != b2[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    abstract void encode(DEROutputStream var1) throws IOException;
}

