/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.IOException;

public class DERVisibleString
extends DERObject
implements DERString {
    String string;

    public static DERVisibleString getInstance(Object obj) {
        if (obj == null || obj instanceof DERVisibleString) {
            return (DERVisibleString)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERVisibleString(((ASN1OctetString)obj).getOctets());
        }
        if (obj instanceof ASN1TaggedObject) {
            return DERVisibleString.getInstance(((ASN1TaggedObject)obj).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERVisibleString getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERVisibleString.getInstance(obj.getObject());
    }

    public DERVisibleString(byte[] string) {
        char[] cs = new char[string.length];
        int i2 = 0;
        while (i2 != cs.length) {
            cs[i2] = (char)(string[i2] & 0xFF);
            ++i2;
        }
        this.string = new String(cs);
    }

    public DERVisibleString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public byte[] getOctets() {
        char[] cs = this.string.toCharArray();
        byte[] bs = new byte[cs.length];
        int i2 = 0;
        while (i2 != cs.length) {
            bs[i2] = (byte)cs[i2];
            ++i2;
        }
        return bs;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(26, this.getOctets());
    }

    public boolean equals(Object o2) {
        if (o2 == null || !(o2 instanceof DERVisibleString)) {
            return false;
        }
        return this.getString().equals(((DERVisibleString)o2).getString());
    }
}

