/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.iia;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.markup.Parser;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Book
extends DefaultHandler {
    public static final Font PART = FontFactory.getFont("Helvetica", "Cp1252", false, 18.0f);
    public static final Font CHAPTER = FontFactory.getFont("Helvetica", "Cp1252", false, 16.0f);
    public static final Font SECTION = FontFactory.getFont("Helvetica", "Cp1252", false, 14.0f);
    public static final Font SUBSECTION = FontFactory.getFont("Helvetica", "Cp1252", false, 12.0f);
    public static final Font TEXT = FontFactory.getFont("Helvetica", "Cp1252", false, 11.0f);
    public static final Font TOC_PART = FontFactory.getFont("Helvetica", "Cp1252", false, 16.0f);
    public static final Font TOC_CHAPTER = FontFactory.getFont("Helvetica", "Cp1252", false, 14.0f);
    public static final Font TOC_SECTION = FontFactory.getFont("Helvetica", "Cp1252", false, 11.0f);
    public static final Font TOC_TEXT = FontFactory.getFont("Helvetica", "Cp1252", false, 9.0f, 2);
    protected Stack filestack;
    protected Stack outline;
    protected Stack tagstack;
    protected Stack attributestack;
    protected int parts = 0;
    protected int chapters = 0;
    protected int framestory = 0;
    protected int sections = 0;
    protected int subsections = 0;
    protected Document document = new Document(new Rectangle(531.0f, 666.0f));
    protected Document toc = new Document(PageSize.LETTER);
    protected PdfWriter writer;

    public static void main(String[] args) {
        String[] structures = new String[]{"top", "part", "chapter", "section", "frame", "subsection"};
        String[] stringArray = new String[6];
        stringArray[1] = "Part";
        stringArray[4] = "Frame Story";
        String[] titles = stringArray;
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[3] = 2;
        nArray[4] = -1;
        nArray[5] = 3;
        int[] parents = nArray;
        Parser parser = new Parser(String.valueOf(args[0]) + "/index.xml", "title", structures, titles, parents);
    }

    public Book(String srcdir, String destdir) {
        try {
            RtfWriter.getInstance(this.document, new FileOutputStream(String.valueOf(destdir) + "/iTextInAction.rtf"));
            RtfWriter.getInstance(this.toc, new FileOutputStream(String.valueOf(destdir) + "/toc.rtf"));
            this.writer = PdfWriter.getInstance(this.document, new FileOutputStream(String.valueOf(destdir) + "/iTextInAction.pdf"));
            PdfWriter.getInstance(this.toc, new FileOutputStream(String.valueOf(destdir) + "/toc.pdf"));
            this.document.open();
            this.toc.open();
            this.tagstack = new Stack();
            this.attributestack = new Stack();
            this.filestack = new Stack();
            this.filestack.push(srcdir);
            this.outline = new Stack();
            PdfContentByte cb = this.writer.getDirectContent();
            this.outline.push(cb.getRootOutline());
            this.parse();
        }
        catch (Exception e2) {
            System.err.println(e2.getMessage());
        }
        this.document.close();
        this.toc.close();
    }

    private void parse() throws ParserConfigurationException, IOException, SAXException {
        String file = this.filestack.peek() + "/index.xml";
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        parser.setContentHandler(this);
        parser.parse(new InputSource(file));
        this.filestack.pop();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tagstack.push(qName);
        Properties attrs = new Properties();
        int i2 = 0;
        while (i2 < attributes.getLength()) {
            attrs.put(attributes.getQName(i2), attributes.getValue(i2));
            ++i2;
        }
        this.attributestack.push(attrs);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.tagstack.pop();
        this.attributestack.pop();
    }

    public void processingInstruction(String instruction, String parameter) throws SAXException {
        try {
            if ("parse".equals(instruction)) {
                StringTokenizer sublevels = new StringTokenizer(parameter, ",");
                while (sublevels.hasMoreTokens()) {
                    String file = sublevels.nextToken();
                    if (this.filestack.size() > 0) {
                        file = this.filestack.peek() + "/" + file;
                    }
                    this.filestack.push(file.trim());
                    this.parse();
                    this.outline.pop();
                }
            }
        }
        catch (Exception e2) {
            throw new SAXException(e2);
        }
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        try {
            Properties attrs = (Properties)this.attributestack.peek();
            if ("title".equals(attrs.get("id"))) {
                String title = new String(arg0, arg1, arg2);
                String level = (String)attrs.get("class");
                if ("top".equals(level)) {
                    Paragraph p = new Paragraph(title, TOC_PART);
                    this.toc.add(p);
                    this.toc.add(new Paragraph("Table of Contents", TOC_CHAPTER));
                    this.toc.add(Chunk.NEWLINE);
                    this.toc.add(Chunk.NEWLINE);
                    p = new Paragraph(title, PART);
                    this.document.add(p);
                    return;
                }
                PdfOutline parent = (PdfOutline)this.outline.peek();
                PdfDestination dest = new PdfDestination(2, this.writer.getVerticalPosition(false));
                if ("part".equals(level)) {
                    ++this.parts;
                    this.toc.add(Chunk.NEWLINE);
                    Paragraph p = new Paragraph("part " + this.parts + ": " + title, TOC_PART);
                    p.setAlignment(2);
                    this.toc.add(p);
                    this.document.newPage();
                    p = new Paragraph("part " + this.parts + ": " + title, PART);
                    p.setAlignment(2);
                    this.document.add(p);
                    this.document.newPage();
                } else if ("chapter".equals(level)) {
                    ++this.chapters;
                    this.sections = 0;
                    Paragraph p = new Paragraph(String.valueOf(String.valueOf(this.chapters)) + " " + title, TOC_CHAPTER);
                    this.toc.add(p);
                    p = new Paragraph(title, CHAPTER);
                    p.setAlignment(2);
                    this.document.add(new Paragraph(String.valueOf(String.valueOf(this.chapters)) + ": " + title, CHAPTER));
                } else if ("frame".equals(level)) {
                    ++this.framestory;
                    Paragraph p = new Paragraph("Frame Story " + this.framestory + ": " + title, TOC_SECTION);
                    p.setIndentationLeft(40.0f);
                    this.toc.add(p);
                    p = new Paragraph("Frame Story " + this.framestory + ": " + title, SECTION);
                    this.document.add(p);
                } else if ("section".equals(level)) {
                    ++this.sections;
                    this.subsections = 0;
                    Paragraph p = new Paragraph(String.valueOf(String.valueOf(this.chapters)) + "." + this.sections + " " + title, TOC_SECTION);
                    p.setIndentationLeft(40.0f);
                    this.toc.add(p);
                    p = new Paragraph(String.valueOf(String.valueOf(this.chapters)) + "." + this.sections + " " + title, SECTION);
                    this.document.add(p);
                } else if ("subsection".equals(level)) {
                    ++this.subsections;
                    Paragraph p = new Paragraph(String.valueOf(String.valueOf(this.chapters)) + "." + this.sections + "." + this.subsections + " " + title, TOC_SECTION);
                    p.setIndentationLeft(50.0f);
                    this.toc.add(p);
                    p = new Paragraph(String.valueOf(String.valueOf(this.chapters)) + "." + this.sections + "." + this.subsections + " " + title, SUBSECTION);
                    this.document.add(p);
                }
                this.outline.push(new PdfOutline(parent, dest, title));
            }
        }
        catch (Exception e2) {
            throw new SAXException(e2);
        }
    }
}

