/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.FontFactory;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;

public class GreekList
extends List {
    protected boolean greeklower;

    public GreekList(int symbolIndent) {
        super(true, symbolIndent);
        this.setGreekFont();
    }

    public GreekList(boolean greeklower, int symbolIndent) {
        super(true, symbolIndent);
        this.greeklower = greeklower;
        this.setGreekFont();
    }

    protected void setGreekFont() {
        float fontsize = this.symbol.font().size();
        this.symbol.setFont(FontFactory.getFont("Symbol", fontsize, 0));
    }

    public void setGreekLower(boolean greeklower) {
        this.greeklower = greeklower;
    }

    public boolean isGreekLower() {
        return this.greeklower;
    }

    public boolean add(Object o2) {
        if (o2 instanceof ListItem) {
            ListItem item = (ListItem)o2;
            Chunk chunk = this.greeklower ? new Chunk((char)(this.first + this.list.size() + 96), this.symbol.font()) : new Chunk((char)(this.first + this.list.size() + 64), this.symbol.font());
            chunk.append(".");
            item.setListSymbol(chunk);
            item.setIndentationLeft(this.symbolIndent);
            item.setIndentationRight(0.0f);
            this.list.add(item);
        } else {
            if (o2 instanceof List) {
                List nested = (List)o2;
                nested.setIndentationLeft(nested.indentationLeft() + this.symbolIndent);
                --this.first;
                return this.list.add(nested);
            }
            if (o2 instanceof String) {
                return this.add(new ListItem((String)o2));
            }
        }
        return false;
    }
}

