/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import com.lowagie.text.Cell;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.xml.SAXmyHandler;
import com.lowagie.text.xml.XmlPeer;
import java.util.HashMap;
import java.util.Properties;
import org.xml.sax.Attributes;

public class SAXmyHtmlHandler
extends SAXmyHandler {
    private Properties bodyAttributes = new Properties();
    private boolean tableBorder = false;

    public SAXmyHtmlHandler(DocListener document) {
        super(document, new HtmlTagMap());
    }

    public SAXmyHtmlHandler(DocListener document, HashMap htmlTags) {
        super(document, htmlTags);
    }

    public void startElement(String uri, String lname, String name, Attributes attrs) {
        if (((HtmlTagMap)this.myTags).isHtml(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isHead(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isTitle(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isMeta(name)) {
            String meta = null;
            String content = null;
            if (attrs != null) {
                int i2 = 0;
                while (i2 < attrs.getLength()) {
                    String attribute = attrs.getQName(i2);
                    if (attribute.equalsIgnoreCase("content")) {
                        content = attrs.getValue(i2);
                    } else if (attribute.equalsIgnoreCase("name")) {
                        meta = attrs.getValue(i2);
                    }
                    ++i2;
                }
            }
            if (meta != null && content != null) {
                this.bodyAttributes.put(meta, content);
            }
            return;
        }
        if (((HtmlTagMap)this.myTags).isLink(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isBody(name)) {
            XmlPeer peer = new XmlPeer("itext", name);
            this.handleStartingTags(peer.getTag(), this.bodyAttributes);
            return;
        }
        if (this.myTags.containsKey(name)) {
            XmlPeer peer = (XmlPeer)this.myTags.get(name);
            if (Table.isTag(peer.getTag()) || Cell.isTag(peer.getTag())) {
                String value;
                Properties p = peer.getAttributes(attrs);
                if (Table.isTag(peer.getTag()) && (value = p.getProperty("borderwidth")) != null) {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(value));
                    if (Float.valueOf(stringBuffer.append("f").toString()).floatValue() > 0.0f) {
                        this.tableBorder = true;
                    }
                }
                if (this.tableBorder) {
                    p.put("left", String.valueOf(true));
                    p.put("right", String.valueOf(true));
                    p.put("top", String.valueOf(true));
                    p.put("bottom", String.valueOf(true));
                }
                this.handleStartingTags(peer.getTag(), p);
                return;
            }
            this.handleStartingTags(peer.getTag(), peer.getAttributes(attrs));
            return;
        }
        Properties attributes = new Properties();
        if (attrs != null) {
            int i3 = 0;
            while (i3 < attrs.getLength()) {
                String attribute = attrs.getQName(i3);
                attributes.setProperty(attribute, attrs.getValue(i3));
                ++i3;
            }
        }
        this.handleStartingTags(name, attributes);
    }

    public void endElement(String uri, String lname, String name) {
        if (Paragraph.isTag(name)) {
            try {
                this.document.add((Element)this.stack.pop());
                return;
            }
            catch (DocumentException e2) {
                throw new ExceptionConverter(e2);
            }
        }
        if (((HtmlTagMap)this.myTags).isHead(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isTitle(name)) {
            if (this.currentChunk != null) {
                this.bodyAttributes.put("title", this.currentChunk.content());
            }
            return;
        }
        if (((HtmlTagMap)this.myTags).isMeta(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isLink(name)) {
            return;
        }
        if (((HtmlTagMap)this.myTags).isBody(name)) {
            return;
        }
        if (this.myTags.containsKey(name)) {
            XmlPeer peer = (XmlPeer)this.myTags.get(name);
            if (Table.isTag(peer.getTag())) {
                this.tableBorder = false;
            }
            super.handleEndingTags(peer.getTag());
            return;
        }
        this.handleEndingTags(name);
    }
}

