/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FactoryProperties {
    public static HashMap colorTable = new HashMap();
    public static HashMap followTags = new HashMap();

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        colorTable.put("black", new Color(0));
        colorTable.put("green", new Color(32768));
        colorTable.put("silver", new Color(0xC0C0C0));
        colorTable.put("lime", new Color(65280));
        colorTable.put("gray", new Color(0x808080));
        colorTable.put("olive", new Color(0x808000));
        colorTable.put("white", new Color(0xFFFFFF));
        colorTable.put("yellow", new Color(0xFFFF00));
        colorTable.put("maroon", new Color(0x800000));
        colorTable.put("navy", new Color(128));
        colorTable.put("red", new Color(0xFF0000));
        colorTable.put("blue", new Color(255));
        colorTable.put("purple", new Color(0x800080));
        colorTable.put("teal", new Color(32896));
        colorTable.put("fuchsia", new Color(0xFF00FF));
        colorTable.put("aqua", new Color(65535));
    }

    public static Chunk createChunk(String text, ChainedProperties props) {
        Chunk ck = new Chunk(text, FactoryProperties.getFont(props));
        if (props.hasProperty("sub")) {
            ck.setTextRise(-6.0f);
        } else if (props.hasProperty("sup")) {
            ck.setTextRise(6.0f);
        }
        return ck;
    }

    public static Paragraph createParagraph(HashMap props) {
        Paragraph p = new Paragraph();
        String value = (String)props.get("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p.setAlignment(3);
            }
        }
        p.setLeading(0.0f, 1.5f);
        return p;
    }

    public static Paragraph createParagraph(ChainedProperties props) {
        Paragraph p = new Paragraph();
        String value = props.getProperty("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p.setAlignment(3);
            }
        }
        p.setLeading(0.0f, 1.5f);
        return p;
    }

    public static Font getFont(ChainedProperties props) {
        String face = props.getProperty("face");
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (FontFactory.isRegistered(face)) break;
            }
        }
        int style = 0;
        if (props.hasProperty("i")) {
            style |= 2;
        }
        if (props.hasProperty("b")) {
            style |= 1;
        }
        if (props.hasProperty("u")) {
            style |= 4;
        }
        String value = props.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.valueOf(value).floatValue();
        }
        Color color = FactoryProperties.decodeColor(props.getProperty("color"));
        return FontFactory.getFont(face, "Cp1252", true, size, style, color);
    }

    public static Color decodeColor(String s) {
        if (s == null) {
            return null;
        }
        Color c2 = (Color)colorTable.get(s = s.toLowerCase().trim());
        if (c2 != null) {
            return c2;
        }
        try {
            if (s.startsWith("#")) {
                return new Color(Integer.parseInt(s.substring(1), 16));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

