/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfString;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class PdfDate
extends PdfString {
    private static final int[] dateSpace;

    static {
        int[] nArray = new int[18];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = -1;
        nArray[6] = 5;
        nArray[7] = 2;
        nArray[9] = 11;
        nArray[10] = 2;
        nArray[12] = 12;
        nArray[13] = 2;
        nArray[15] = 13;
        nArray[16] = 2;
        dateSpace = nArray;
    }

    public PdfDate(Calendar d2) {
        StringBuffer date = new StringBuffer("D:");
        date.append(this.setLength(d2.get(1), 4));
        date.append(this.setLength(d2.get(2) + 1, 2));
        date.append(this.setLength(d2.get(5), 2));
        date.append(this.setLength(d2.get(11), 2));
        date.append(this.setLength(d2.get(12), 2));
        date.append(this.setLength(d2.get(13), 2));
        int timezone = d2.get(15) / 3600000;
        if (timezone == 0) {
            date.append("Z");
        } else if (timezone < 0) {
            date.append("-");
            timezone = -timezone;
        } else {
            date.append("+");
        }
        if (timezone != 0) {
            date.append(this.setLength(timezone, 2)).append("'");
            int zone = Math.abs(d2.get(15) / 60000) - timezone * 60;
            date.append(this.setLength(zone, 2)).append("'");
        }
        this.value = date.toString();
    }

    public PdfDate() {
        this(new GregorianCalendar());
    }

    private String setLength(int i2, int length) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(i2);
        while (tmp.length() < length) {
            tmp.insert(0, "0");
        }
        tmp.setLength(length);
        return tmp.toString();
    }

    public static Calendar decode(String s) {
        try {
            GregorianCalendar calendar;
            if (s.startsWith("D:")) {
                s = s.substring(2);
            }
            int slen = s.length();
            int idx = s.indexOf(90);
            if (idx >= 0) {
                slen = idx;
                calendar = new GregorianCalendar(new SimpleTimeZone(0, "ZPDF"));
            } else {
                int sign = 1;
                idx = s.indexOf(43);
                if (idx < 0 && (idx = s.indexOf(45)) >= 0) {
                    sign = -1;
                }
                if (idx < 0) {
                    calendar = new GregorianCalendar();
                } else {
                    int offset = Integer.parseInt(s.substring(idx + 1, idx + 3)) * 60;
                    if (idx + 5 < s.length()) {
                        offset += Integer.parseInt(s.substring(idx + 4, idx + 6));
                    }
                    calendar = new GregorianCalendar(new SimpleTimeZone(offset * sign * 60000, "ZPDF"));
                    slen = idx;
                }
            }
            calendar.clear();
            idx = 0;
            int k2 = 0;
            while (k2 < dateSpace.length) {
                if (idx >= slen) break;
                calendar.set(dateSpace[k2], Integer.parseInt(s.substring(idx, idx + dateSpace[k2 + 1])) + dateSpace[k2 + 2]);
                idx += dateSpace[k2 + 1];
                k2 += 3;
            }
            return calendar;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

