/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.postscript;

import com.lowagie.text.pdf.codec.postscript.PACommand;
import com.lowagie.text.pdf.codec.postscript.PAContext;
import com.lowagie.text.pdf.codec.postscript.PAToken;
import com.lowagie.text.pdf.codec.postscript.PainterException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class PAEngine {
    public static final int MODE_STACK = 0;
    public static final int MODE_PROCEDURE = 1;
    public static final int MODE_ARRAY = 2;
    protected PAContext context;
    protected int mode;
    protected Stack procedure;
    protected int innerProcedures;

    public PAEngine(PAContext context) {
        this.context = context;
        this.mode = 0;
    }

    public void startProcedure() throws PainterException {
        this.procedure = new Stack();
        this.mode = 1;
        this.innerProcedures = 0;
    }

    public void endProcedure() throws PainterException {
        this.context.operands.push(new PAToken(this.procedure, 2));
        this.mode = 0;
    }

    public void bindProcedure(PAToken patoken) {
        Stack oldStack = (Stack)patoken.value;
        Stack<Object> newStack = new Stack<Object>();
        int n2 = oldStack.size();
        int i2 = 0;
        while (i2 < n2) {
            Object token = oldStack.elementAt(i2);
            if (token instanceof PAToken && ((PAToken)token).type == 0) {
                Object foundToken = this.context.findIdentifier(((PAToken)token).value);
                if (foundToken == null) {
                    newStack.push(token);
                } else {
                    newStack.push(foundToken);
                }
            } else {
                newStack.push(token);
            }
            ++i2;
        }
        patoken.value = newStack;
    }

    public void process(Object token) throws PainterException {
        block20: {
            block18: {
                block21: {
                    block19: {
                        if (token == null) {
                            throw new IllegalStateException("Null token encountered; last unknown identifier was " + this.context.getLastUnknownIdentifier());
                        }
                        if (token instanceof PAToken && ((PAToken)token).type == 6) {
                            Object foundValue = this.context.findIdentifier(((PAToken)token).value);
                            this.process(foundValue);
                            return;
                        }
                        if (this.mode != 0) break block18;
                        if (!(token instanceof PACommand)) break block19;
                        ((PACommand)token).execute(this.context);
                        break block20;
                    }
                    if (!(token instanceof PAToken)) break block21;
                    PAToken patoken = (PAToken)token;
                    switch (patoken.type) {
                        case 0: {
                            this.process(this.context.findIdentifier(patoken.value));
                            break block20;
                        }
                        case 1: 
                        case 3: 
                        case 7: {
                            this.context.operands.push(token);
                            break block20;
                        }
                        case 2: {
                            Enumeration enumx = ((Vector)patoken.value).elements();
                            while (enumx.hasMoreElements()) {
                                this.process(enumx.nextElement());
                            }
                            break block20;
                        }
                        case 4: {
                            this.startProcedure();
                            break block20;
                        }
                        case 8: {
                            this.context.collectArray();
                            break block20;
                        }
                        default: {
                            throw new IllegalStateException("Unknown token encountered" + token);
                        }
                    }
                }
                this.context.operands.push(token);
                break block20;
            }
            if (this.mode == 1) {
                if (token instanceof PAToken) {
                    PAToken patoken = (PAToken)token;
                    switch (patoken.type) {
                        case 4: {
                            ++this.innerProcedures;
                            this.procedure.push(token);
                            break;
                        }
                        case 5: {
                            if (this.innerProcedures > 0) {
                                --this.innerProcedures;
                                this.procedure.push(token);
                                break;
                            }
                            this.endProcedure();
                            break;
                        }
                        default: {
                            this.procedure.push(token);
                            break;
                        }
                    }
                } else {
                    this.procedure.push(token);
                }
            }
        }
    }
}

