/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.ByteVector;
import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.HyphenationException;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import com.lowagie.text.pdf.hyphenation.SimplePatternParser;
import com.lowagie.text.pdf.hyphenation.TernaryTree;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer,
Serializable {
    protected ByteVector vspace;
    protected HashMap stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String values) {
        int n2 = values.length();
        int m2 = (n2 & 1) == 1 ? (n2 >> 1) + 2 : (n2 >> 1) + 1;
        int offset = this.vspace.alloc(m2);
        byte[] va = this.vspace.getArray();
        int i2 = 0;
        while (i2 < n2) {
            int j2 = i2 >> 1;
            byte v = (byte)(values.charAt(i2) - 48 + 1 & 0xF);
            va[j2 + offset] = (i2 & 1) == 1 ? (byte)(va[j2 + offset] | v) : (byte)(v << 4);
            ++i2;
        }
        va[m2 - 1 + offset] = 0;
        return offset;
    }

    protected String unpackValues(int k2) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k2++);
        while (v != 0) {
            char c2 = (char)((v >>> 4) - 1 + 48);
            buf.append(c2);
            c2 = (char)(v & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001' + 48);
            buf.append(c2);
            v = this.vspace.get(k2++);
        }
        return buf.toString();
    }

    public void loadSimplePatterns(InputStream stream) throws HyphenationException {
        SimplePatternParser pp = new SimplePatternParser();
        this.ivalues = new TernaryTree();
        pp.parse(stream, this);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String pat) {
        int k2 = super.find(pat);
        if (k2 >= 0) {
            return this.unpackValues(k2);
        }
        return "";
    }

    protected int hstrcmp(char[] s, int si, char[] t, int ti) {
        while (s[si] == t[ti]) {
            if (s[si] == '\u0000') {
                return 0;
            }
            ++si;
            ++ti;
        }
        if (t[ti] == '\u0000') {
            return 0;
        }
        return s[si] - t[ti];
    }

    protected byte[] getValues(int k2) {
        StringBuffer buf = new StringBuffer();
        byte v = this.vspace.get(k2++);
        while (v != 0) {
            char c2 = (char)((v >>> 4) - 1);
            buf.append(c2);
            c2 = (char)(v & 0xF);
            if (c2 == '\u0000') break;
            c2 = (char)(c2 - '\u0001');
            buf.append(c2);
            v = this.vspace.get(k2++);
        }
        byte[] res = new byte[buf.length()];
        int i2 = 0;
        while (i2 < res.length) {
            res[i2] = (byte)buf.charAt(i2);
            ++i2;
        }
        return res;
    }

    protected void searchPatterns(char[] word, int index, byte[] il) {
        int i2 = index;
        char sp = word[i2];
        char p = this.root;
        block0: while (p > '\u0000' && p < this.sc.length) {
            byte[] values;
            if (this.sc[p] == '\uffff') {
                if (this.hstrcmp(word, i2, this.kv.getArray(), this.lo[p]) == 0) {
                    values = this.getValues(this.eq[p]);
                    int j2 = index;
                    int k2 = 0;
                    while (k2 < values.length) {
                        if (j2 < il.length && values[k2] > il[j2]) {
                            il[j2] = values[k2];
                        }
                        ++j2;
                        ++k2;
                    }
                }
                return;
            }
            int d2 = sp - this.sc[p];
            if (d2 == 0) {
                if (sp == '\u0000') break;
                sp = word[++i2];
                char q = p = this.eq[p];
                while (q > '\u0000' && q < this.sc.length) {
                    if (this.sc[q] == '\uffff') continue block0;
                    if (this.sc[q] == '\u0000') {
                        values = this.getValues(this.eq[q]);
                        int j3 = index;
                        int k3 = 0;
                        while (k3 < values.length) {
                            if (j3 < il.length && values[k3] > il[j3]) {
                                il[j3] = values[k3];
                            }
                            ++j3;
                            ++k3;
                        }
                        continue block0;
                    }
                    q = this.lo[q];
                }
                continue;
            }
            char c2 = p = d2 < 0 ? this.lo[p] : this.hi[p];
        }
    }

    public Hyphenation hyphenate(String word, int remainCharCount, int pushCharCount) {
        char[] w = word.toCharArray();
        return this.hyphenate(w, 0, w.length, remainCharCount, pushCharCount);
    }

    public Hyphenation hyphenate(char[] w, int offset, int len, int remainCharCount, int pushCharCount) {
        char[] word = new char[len + 3];
        char[] c2 = new char[2];
        int iIgnoreAtBeginning = 0;
        int iLength = len;
        boolean bEndOfLetters = false;
        int i2 = 1;
        while (i2 <= len) {
            c2[0] = w[offset + i2 - 1];
            int nc = this.classmap.find(c2, 0);
            if (nc < 0) {
                if (i2 == 1 + iIgnoreAtBeginning) {
                    ++iIgnoreAtBeginning;
                } else {
                    bEndOfLetters = true;
                }
                --iLength;
            } else if (!bEndOfLetters) {
                word[i2 - iIgnoreAtBeginning] = (char)nc;
            } else {
                return null;
            }
            ++i2;
        }
        len = iLength;
        if (len < remainCharCount + pushCharCount) {
            return null;
        }
        int[] result = new int[len + 1];
        int k2 = 0;
        String sw = new String(word, 1, len);
        if (this.stoplist.containsKey(sw)) {
            ArrayList hw = (ArrayList)this.stoplist.get(sw);
            int j2 = 0;
            i2 = 0;
            while (i2 < hw.size()) {
                Object o2 = hw.get(i2);
                if (o2 instanceof String && (j2 += ((String)o2).length()) >= remainCharCount && j2 < len - pushCharCount) {
                    result[k2++] = j2 + iIgnoreAtBeginning;
                }
                ++i2;
            }
        } else {
            word[0] = 46;
            word[len + 1] = 46;
            word[len + 2] = '\u0000';
            byte[] il = new byte[len + 3];
            i2 = 0;
            while (i2 < len + 1) {
                this.searchPatterns(word, i2, il);
                ++i2;
            }
            i2 = 0;
            while (i2 < len) {
                if ((il[i2 + 1] & 1) == 1 && i2 >= remainCharCount && i2 <= len - pushCharCount) {
                    result[k2++] = i2 + iIgnoreAtBeginning;
                }
                ++i2;
            }
        }
        if (k2 > 0) {
            int[] res = new int[k2];
            System.arraycopy(result, 0, res, 0, k2);
            return new Hyphenation(new String(w, offset, len), res);
        }
        return null;
    }

    public void addClass(String chargroup) {
        if (chargroup.length() > 0) {
            char equivChar = chargroup.charAt(0);
            char[] key = new char[2];
            key[1] = '\u0000';
            int i2 = 0;
            while (i2 < chargroup.length()) {
                key[0] = chargroup.charAt(i2);
                this.classmap.insert(key, 0, equivChar);
                ++i2;
            }
        }
    }

    public void addException(String word, ArrayList hyphenatedword) {
        this.stoplist.put(word, hyphenatedword);
    }

    public void addPattern(String pattern, String ivalue) {
        int k2 = this.ivalues.find(ivalue);
        if (k2 <= 0) {
            k2 = this.packValues(ivalue);
            this.ivalues.insert(ivalue, (char)k2);
        }
        this.insert(pattern, (char)k2);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }
}

