/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocumentException;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfMapper;
import com.lowagie.text.rtf.document.RtfDocumentHeader;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.output.RtfDataCache;
import com.lowagie.text.rtf.document.output.RtfDiskCache;
import com.lowagie.text.rtf.document.output.RtfMemoryCache;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfDocument
extends RtfElement {
    private RtfDataCache data = new RtfMemoryCache();
    private RtfMapper mapper = new RtfMapper(this);
    private RtfDocumentHeader documentHeader = new RtfDocumentHeader(this);
    private ArrayList previousRandomInts = null;
    private boolean autogenerateTOCEntries = false;
    private boolean dataWritten = false;
    private static final byte[] RTF_DOCUMENT = "\\rtf1".getBytes();

    public RtfDocument() {
        super(null);
        this.documentHeader.init();
        this.previousRandomInts = new ArrayList();
    }

    public byte[] writeDocument() {
        ByteArrayOutputStream docStream = new ByteArrayOutputStream();
        try {
            docStream.write(RtfBasicElement.OPEN_GROUP);
            docStream.write(RTF_DOCUMENT);
            docStream.write(this.documentHeader.write());
            this.data.writeTo(docStream);
            docStream.write(RtfBasicElement.CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return docStream.toByteArray();
    }

    public void add(RtfBasicElement element) {
        try {
            if (element instanceof RtfInfoElement) {
                this.documentHeader.addInfoElement((RtfInfoElement)element);
            } else {
                this.dataWritten = true;
                this.data.getOutputStream().write(element.write());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public RtfMapper getMapper() {
        return this.mapper;
    }

    public int getRandomInt() {
        Integer newInt = null;
        while (this.previousRandomInts.contains(newInt = new Integer((int)(Math.random() * 2.147483647E9)))) {
        }
        this.previousRandomInts.add(newInt);
        return newInt;
    }

    public RtfDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public String filterSpecialChar(String str, boolean useHex, boolean softLineBreaks) {
        int length = str.length();
        char z = 'z';
        StringBuffer ret = new StringBuffer(length);
        int i2 = 0;
        while (i2 < length) {
            char ch = str.charAt(i2);
            if (ch == '\\') {
                ret.append("\\\\");
            } else if (ch == '\n') {
                if (softLineBreaks) {
                    ret.append("\\line ");
                } else {
                    ret.append("\\par ");
                }
            } else if (ch == '\t') {
                ret.append("\\tab");
            } else if (ch > z) {
                if (useHex) {
                    ret.append("\\'").append(Long.toHexString(ch));
                } else {
                    ret.append("\\u").append((long)ch).append('?');
                }
            } else {
                ret.append(ch);
            }
            ++i2;
        }
        String s = ret.toString();
        if (s.indexOf("$newpage$") >= 0) {
            String before = s.substring(0, s.indexOf("$newpage$"));
            String after = s.substring(s.indexOf("$newpage$") + 9);
            ret = new StringBuffer(before);
            ret.append("\\page\\par ");
            ret.append(after);
            return ret.toString();
        }
        return s;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.autogenerateTOCEntries = autogenerate;
    }

    public boolean getAutogenerateTOCEntries() {
        return this.autogenerateTOCEntries;
    }

    public void setDataCacheStyle(int dataCacheStyle) throws DocumentException, IOException {
        if (this.dataWritten) {
            throw new DocumentException("Data has already been written into the data cache. You can not change the cache style anymore.");
        }
        switch (dataCacheStyle) {
            case 2: {
                this.data = new RtfMemoryCache();
                break;
            }
            case 1: {
                this.data = new RtfDiskCache();
                break;
            }
            default: {
                this.data = new RtfMemoryCache();
            }
        }
    }
}

