/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = "\\pard".getBytes();
    protected static final byte[] IN_TABLE = "\\intbl".getBytes();
    public static final byte[] LINE_SPACING = "\\sl".getBytes();
    protected ArrayList chunks = new ArrayList();
    protected int lineLeading = 0;

    public RtfPhrase(RtfDocument doc, Phrase phrase) {
        super(doc);
        if (phrase == null) {
            return;
        }
        this.lineLeading = phrase.leadingDefined() ? (int)((double)phrase.leading() * 20.0) : 0;
        RtfFont phraseFont = new RtfFont(null, phrase.font());
        int i2 = 0;
        while (i2 < phrase.size()) {
            Element chunk = (Element)phrase.get(i2);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(phraseFont.difference(((Chunk)chunk).font()));
            }
            try {
                this.chunks.add(doc.getMapper().mapElement(chunk));
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            ++i2;
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                result.write(IN_TABLE);
            }
            if (this.lineLeading > 0) {
                result.write(LINE_SPACING);
                result.write(this.intToByteArray(this.lineLeading));
            }
            int i2 = 0;
            while (i2 < this.chunks.size()) {
                result.write(((RtfBasicElement)this.chunks.get(i2)).write());
                ++i2;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        int i2 = 0;
        while (i2 < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i2)).setInTable(inTable);
            ++i2;
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        int i2 = 0;
        while (i2 < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i2)).setInHeader(inHeader);
            ++i2;
        }
    }

    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        int i2 = 0;
        while (i2 < this.chunks.size()) {
            ((RtfBasicElement)this.chunks.get(i2)).setRtfDocument(this.document);
            ++i2;
        }
    }
}

