/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class concat_pdf {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("arguments: file1 [file2 ...] destfile");
        } else {
            try {
                int pageOffset = 0;
                ArrayList master = new ArrayList();
                int f2 = 0;
                String outFile = args[args.length - 1];
                Document document = null;
                PdfCopy writer = null;
                while (f2 < args.length - 1) {
                    PdfReader reader = new PdfReader(args[f2]);
                    reader.consolidateNamedDestinations();
                    int n2 = reader.getNumberOfPages();
                    List bookmarks = SimpleBookmark.getBookmark(reader);
                    if (bookmarks != null) {
                        if (pageOffset != 0) {
                            SimpleBookmark.shiftPageNumbers(bookmarks, pageOffset, null);
                        }
                        master.addAll(bookmarks);
                    }
                    pageOffset += n2;
                    System.out.println("There are " + n2 + " pages in " + args[f2]);
                    if (f2 == 0) {
                        document = new Document(reader.getPageSizeWithRotation(1));
                        writer = new PdfCopy(document, (OutputStream)new FileOutputStream(outFile));
                        document.open();
                    }
                    int i2 = 0;
                    while (i2 < n2) {
                        PdfImportedPage page = writer.getImportedPage(reader, ++i2);
                        writer.addPage(page);
                        System.out.println("Processed page " + i2);
                    }
                    PRAcroForm form = reader.getAcroForm();
                    if (form != null) {
                        writer.copyAcroForm(reader);
                    }
                    ++f2;
                }
                if (master.size() > 0) {
                    writer.setOutlines(master);
                }
                document.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

