/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.codec.TiffImage;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.ImageFilter;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class KnitTiff
extends AbstractTool {
    public KnitTiff() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "odd", "The tiff file with the odd pages", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "even", "The tiff file with the even pages", false, new ImageFilter(false, false, false, false, false, true)));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the converted TIFF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("KnitTiff", true, true, true);
        this.internalFrame.setSize(550, 250);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(40, 30));
    }

    public void execute() {
        try {
            if (this.getValue("odd") == null) {
                throw new InstantiationException("You need to choose a sourcefile for the odd pages");
            }
            File odd_file = (File)this.getValue("odd");
            if (this.getValue("even") == null) {
                throw new InstantiationException("You need to choose a sourcefile for the even pages");
            }
            File even_file = (File)this.getValue("even");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File pdf_file = (File)this.getValue("destfile");
            RandomAccessFileOrArray odd = new RandomAccessFileOrArray(odd_file.getAbsolutePath());
            RandomAccessFileOrArray even = new RandomAccessFileOrArray(even_file.getAbsolutePath());
            Image img = TiffImage.getTiffImage(odd, 1);
            Document document = new Document(new Rectangle(img.scaledWidth(), img.scaledHeight()));
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(pdf_file));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int count = Math.max(TiffImage.getNumberOfPages(odd), TiffImage.getNumberOfPages(even));
            int c2 = 0;
            while (c2 < count) {
                try {
                    Image imgOdd = TiffImage.getTiffImage(odd, c2 + 1);
                    Image imgEven = TiffImage.getTiffImage(even, count - c2);
                    document.setPageSize(new Rectangle(imgOdd.scaledWidth(), imgOdd.scaledHeight()));
                    document.newPage();
                    imgOdd.setAbsolutePosition(0.0f, 0.0f);
                    cb.addImage(imgOdd);
                    document.setPageSize(new Rectangle(imgEven.scaledWidth(), imgEven.scaledHeight()));
                    document.newPage();
                    imgEven.setAbsolutePosition(0.0f, 0.0f);
                    cb.addImage(imgEven);
                }
                catch (Exception e2) {
                    System.out.println("Exception page " + (c2 + 1) + " " + e2.getMessage());
                }
                ++c2;
            }
            odd.close();
            even.close();
            document.close();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        KnitTiff tool = new KnitTiff();
        if (args.length < 3) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

