/*
 * Decompiled with CFR 0.152.
 */
package giovynet.bt;

import giovynet.bt.Parameter;
import giovynet.bt.Variable;
import giovynet.serial.Baud;
import giovynet.serial.Com;

public class Command {
    private Com com;

    public Command(Com com) {
        this.com = com;
    }

    public void goToCommandMode() throws GiovynetBTException {
        try {
            Thread.sleep(1000L);
            this.com.sendString("+++");
            Thread.sleep(1000L);
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'goToCommandMode', " + e2.toString());
        }
    }

    public void setBaudRate(Baud baud) throws GiovynetBTException {
        try {
            this.com.sendString("set baud " + baud.getValue());
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'setBaud', " + e2.toString());
        }
    }

    public void connection(String addres) throws GiovynetBTException {
        try {
            this.com.sendString("con " + addres);
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'connection', " + e2.toString());
        }
    }

    public void delTrusted(String addres) throws GiovynetBTException {
        try {
            this.com.sendString("del trusted " + addres);
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'delTrusted':" + addres + ", " + e2.toString());
        }
    }

    public void delTrustedAll() throws GiovynetBTException {
        try {
            this.com.sendString("del trusted all");
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'delTrustedAll, " + e2.toString());
        }
    }

    public void disconnects() throws GiovynetBTException {
        try {
            this.com.sendString("dis");
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'disconnects', " + e2.toString());
        }
    }

    public void listTrusted(boolean includesNames, int timeout) throws GiovynetBTException {
        try {
            if (includesNames) {
                this.com.sendString("lst trusted name " + timeout);
                this.com.sendSingleData(13);
            } else {
                this.com.sendString("lst trusted " + timeout);
                this.com.sendSingleData(13);
            }
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'listTrusted', " + e2.toString());
        }
    }

    public void listVisible(boolean includesNames, int timeout) throws GiovynetBTException {
        try {
            if (includesNames) {
                this.com.sendString("lst visible name " + timeout);
                this.com.sendSingleData(13);
            } else {
                this.com.sendString("lst visible " + timeout);
                this.com.sendSingleData(13);
            }
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'listTrusted', " + e2.toString());
        }
    }

    public void returnDataMode() throws GiovynetBTException {
        try {
            this.com.sendString("ret");
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'returnDataMode', " + e2.toString());
        }
    }

    public void inquireParameter(Parameter parameter) throws GiovynetBTException {
        try {
            this.com.sendString("get " + parameter.getValue());
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'getParameter', " + e2.toString());
        }
    }

    public void setVariable(Variable variable, String value) throws GiovynetBTException {
        try {
            this.com.sendString("set " + variable.getValue() + " " + value);
            this.com.sendSingleData(13);
        }
        catch (Exception e2) {
            throw new GiovynetBTException("Exception try 'setVariable', " + e2.toString());
        }
    }

    public Com getCom() {
        return this.com;
    }

    public class GiovynetBTException
    extends Exception {
        public GiovynetBTException(String message) {
            super(message);
        }
    }
}

