/*
 * Decompiled with CFR 0.152.
 */
package grandchef.server;

import grandchef.server.ThreadHandler;
import grandchef.server.UpdateChecker;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class GrandChefServer {
    public static String version = "2";

    public static void main(String[] args) throws Exception {
        UpdateChecker updateChecker = new UpdateChecker(version);
        int nreq = 1;
        try {
            System.out.println("-------- PostgreSQL JDBC Connection Testing ------------\nUsing curent code version : " + version);
            try {
                Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e2) {
                System.out.println("Where is your PostgreSQL JDBC Driver? Include in your library path!");
                e2.printStackTrace();
                return;
            }
            System.out.println("PostgreSQL JDBC Driver Registered!");
            Connection connection = null;
            try {
                connection = DriverManager.getConnection("jdbc:postgresql://" + args[0] + ":5432/" + args[1], "postgres", "123456");
            }
            catch (SQLException e3) {
                System.out.println("Connection Failed! Check output console");
                e3.printStackTrace();
                return;
            }
            if (connection != null) {
                System.out.println("You made it, take control your database now!");
            } else {
                System.out.println("Failed to make connection!");
            }
            ServerSocket sock = new ServerSocket(9999);
            while (true) {
                Socket newsock = sock.accept();
                System.out.println("Creating thread ...");
                ThreadHandler t = new ThreadHandler(newsock, nreq, connection);
                t.start();
            }
        }
        catch (Exception e4) {
            System.out.println("IO error " + e4);
            e4.printStackTrace();
            System.out.println("End!");
            return;
        }
    }
}

