/*
 * Decompiled with CFR 0.152.
 */
package groovy.text;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;

public class SimpleTemplateEngine
extends TemplateEngine {
    private boolean verbose;
    private static int counter = 1;
    private GroovyShell groovyShell;

    public SimpleTemplateEngine() {
        this(GroovyShell.class.getClassLoader());
    }

    public SimpleTemplateEngine(boolean verbose) {
        this(GroovyShell.class.getClassLoader());
        this.setVerbose(verbose);
    }

    public SimpleTemplateEngine(ClassLoader parentLoader) {
        this(new GroovyShell(parentLoader));
    }

    public SimpleTemplateEngine(GroovyShell groovyShell) {
        this.groovyShell = groovyShell;
    }

    public Template createTemplate(Reader reader) throws CompilationFailedException, IOException {
        SimpleTemplate template = new SimpleTemplate();
        String script = template.parse(reader);
        if (this.verbose) {
            System.out.println("\n-- script source --");
            System.out.print(script);
            System.out.println("\n-- script end --\n");
        }
        try {
            template.script = this.groovyShell.parse(script, "SimpleTemplateScript" + counter++ + ".groovy");
        }
        catch (Exception e2) {
            throw new GroovyRuntimeException("Failed to parse template script (your template may contain an error or be trying to use expressions not currently supported): " + e2.getMessage());
        }
        return template;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    private static class SimpleTemplate
    implements Template {
        protected Script script;

        private SimpleTemplate() {
        }

        public Writable make() {
            return this.make(null);
        }

        public Writable make(final Map map) {
            return new Writable(){

                public Writer writeTo(Writer writer) {
                    Binding binding = map == null ? new Binding() : new Binding(map);
                    Script scriptObject = InvokerHelper.createScript(SimpleTemplate.this.script.getClass(), binding);
                    PrintWriter pw = new PrintWriter(writer);
                    scriptObject.setProperty("out", pw);
                    scriptObject.run();
                    pw.flush();
                    return writer;
                }

                public String toString() {
                    StringWriter sw = new StringWriter();
                    this.writeTo(sw);
                    return sw.toString();
                }
            };
        }

        protected String parse(Reader reader) throws IOException {
            int c2;
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader);
            }
            StringWriter sw = new StringWriter();
            this.startScript(sw);
            while ((c2 = reader.read()) != -1) {
                if (c2 == 60) {
                    reader.mark(1);
                    c2 = reader.read();
                    if (c2 != 37) {
                        sw.write(60);
                        reader.reset();
                        continue;
                    }
                    reader.mark(1);
                    c2 = reader.read();
                    if (c2 == 61) {
                        this.groovyExpression(reader, sw);
                        continue;
                    }
                    reader.reset();
                    this.groovySection(reader, sw);
                    continue;
                }
                if (c2 == 36) {
                    reader.mark(1);
                    c2 = reader.read();
                    if (c2 != 123) {
                        sw.write(36);
                        reader.reset();
                        continue;
                    }
                    reader.mark(1);
                    sw.write("${");
                    this.processGSstring(reader, sw);
                    continue;
                }
                if (c2 == 34) {
                    sw.write(92);
                }
                if (c2 == 10 || c2 == 13) {
                    if (c2 == 13) {
                        reader.mark(1);
                        c2 = reader.read();
                        if (c2 != 10) {
                            reader.reset();
                        }
                    }
                    sw.write("\\n\");\nout.print(\"");
                    continue;
                }
                sw.write(c2);
            }
            this.endScript(sw);
            return sw.toString();
        }

        private void startScript(StringWriter sw) {
            sw.write("/* Generated by SimpleTemplateEngine */\n");
            sw.write("out.print(\"");
        }

        private void endScript(StringWriter sw) {
            sw.write("\");\n");
        }

        private void processGSstring(Reader reader, StringWriter sw) throws IOException {
            int c2;
            while ((c2 = reader.read()) != -1) {
                if (c2 != 10 && c2 != 13) {
                    sw.write(c2);
                }
                if (c2 != 125) continue;
                break;
            }
        }

        private void groovyExpression(Reader reader, StringWriter sw) throws IOException {
            int c2;
            sw.write("\");out.print(\"${");
            while ((c2 = reader.read()) != -1) {
                if (c2 == 37) {
                    c2 = reader.read();
                    if (c2 == 62) break;
                    sw.write(37);
                }
                if (c2 == 10 || c2 == 13) continue;
                sw.write(c2);
            }
            sw.write("}\");\nout.print(\"");
        }

        private void groovySection(Reader reader, StringWriter sw) throws IOException {
            int c2;
            sw.write("\");");
            while ((c2 = reader.read()) != -1) {
                if (c2 == 37) {
                    c2 = reader.read();
                    if (c2 == 62) break;
                    sw.write(37);
                }
                sw.write(c2);
            }
            sw.write(";\nout.print(\"");
        }
    }
}

