/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarasm.asm.tree;

import groovyjarjarasm.asm.Attribute;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.FieldVisitor;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.tree.AnnotationNode;
import groovyjarjarasm.asm.tree.FieldNode;
import groovyjarjarasm.asm.tree.InnerClassNode;
import groovyjarjarasm.asm.tree.MemberNode;
import groovyjarjarasm.asm.tree.MethodNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassNode
extends MemberNode
implements ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public final List interfaces = new ArrayList();
    public String sourceFile;
    public String sourceDebug;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public final List innerClasses = new ArrayList();
    public final List fields = new ArrayList();
    public final List methods = new ArrayList();

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        this.version = n2;
        this.access = n3;
        this.name = string;
        this.signature = string2;
        this.superName = string3;
        if (stringArray != null) {
            this.interfaces.addAll(Arrays.asList(stringArray));
        }
    }

    public void visitSource(String string, String string2) {
        this.sourceFile = string;
        this.sourceDebug = string2;
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.outerClass = string;
        this.outerMethod = string2;
        this.outerMethodDesc = string3;
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        InnerClassNode innerClassNode = new InnerClassNode(string, string2, string3, n2);
        this.innerClasses.add(innerClassNode);
    }

    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        FieldNode fieldNode = new FieldNode(n2, string, string2, string3, object);
        this.fields.add(fieldNode);
        return fieldNode;
    }

    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        MethodNode methodNode = new MethodNode(n2, string, string2, string3, stringArray);
        this.methods.add(methodNode);
        return methodNode;
    }

    public void visitEnd() {
    }

    public void accept(ClassVisitor classVisitor) {
        AnnotationNode annotationNode;
        int n2;
        String[] stringArray = new String[this.interfaces.size()];
        this.interfaces.toArray(stringArray);
        classVisitor.visit(this.version, this.access, this.name, this.signature, this.superName, stringArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.outerClass != null) {
            classVisitor.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        int n3 = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            annotationNode = (AnnotationNode)this.visibleAnnotations.get(n2);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, true));
        }
        n3 = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            annotationNode = (AnnotationNode)this.invisibleAnnotations.get(n2);
            annotationNode.accept(classVisitor.visitAnnotation(annotationNode.desc, false));
        }
        n3 = this.attrs == null ? 0 : this.attrs.size();
        for (n2 = 0; n2 < n3; ++n2) {
            classVisitor.visitAttribute((Attribute)this.attrs.get(n2));
        }
        for (n2 = 0; n2 < this.innerClasses.size(); ++n2) {
            ((InnerClassNode)this.innerClasses.get(n2)).accept(classVisitor);
        }
        for (n2 = 0; n2 < this.fields.size(); ++n2) {
            ((FieldNode)this.fields.get(n2)).accept(classVisitor);
        }
        for (n2 = 0; n2 < this.methods.size(); ++n2) {
            ((MethodNode)this.methods.get(n2)).accept(classVisitor);
        }
        classVisitor.visitEnd();
    }
}

