/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.DuplicatesPredicate;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.MethodInfoTransformer;
import net.sf.cglib.core.MethodWrapper;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.ProcessSwitchCallback;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.RejectModifierPredicate;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.Transformer;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.CallbackGenerator;
import net.sf.cglib.proxy.CallbackInfo;
import net.sf.cglib.proxy.Factory;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class Enhancer
extends AbstractClassGenerator {
    private static final CallbackFilter ALL_ZERO = new CallbackFilter(){

        public int accept(Method method) {
            return 0;
        }
    };
    private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$net$sf$cglib$proxy$Enhancer == null ? (class$net$sf$cglib$proxy$Enhancer = Enhancer.class$("net.sf.cglib.proxy.Enhancer")) : class$net$sf$cglib$proxy$Enhancer).getName());
    private static final EnhancerKey KEY_FACTORY = (EnhancerKey)((Object)KeyFactory.create(class$net$sf$cglib$proxy$Enhancer$EnhancerKey == null ? (class$net$sf$cglib$proxy$Enhancer$EnhancerKey = Enhancer.class$("net.sf.cglib.proxy.Enhancer$EnhancerKey")) : class$net$sf$cglib$proxy$Enhancer$EnhancerKey, KeyFactory.CLASS_BY_NAME));
    private static final String BOUND_FIELD = "CGLIB$BOUND";
    private static final String THREAD_CALLBACKS_FIELD = "CGLIB$THREAD_CALLBACKS";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final String CONSTRUCTED_FIELD = "CGLIB$CONSTRUCTED";
    private static final Type FACTORY = TypeUtils.parseType("net.sf.cglib.proxy.Factory");
    private static final Type ILLEGAL_STATE_EXCEPTION = TypeUtils.parseType("IllegalStateException");
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = TypeUtils.parseType("IllegalArgumentException");
    private static final Type THREAD_LOCAL = TypeUtils.parseType("ThreadLocal");
    private static final Type CALLBACK = TypeUtils.parseType("net.sf.cglib.proxy.Callback");
    private static final Type CALLBACK_ARRAY = Type.getType("[Lnet/sf/cglib/proxy/Callback;");
    private static final Signature CSTRUCT_NULL = TypeUtils.parseConstructor("");
    private static final Signature SET_THREAD_CALLBACKS = new Signature("CGLIB$SET_THREAD_CALLBACKS", Type.VOID_TYPE, new Type[]{CALLBACK_ARRAY});
    private static final Signature NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new Type[]{CALLBACK_ARRAY});
    private static final Signature MULTIARG_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_CLASS_ARRAY, Constants.TYPE_OBJECT_ARRAY, CALLBACK_ARRAY});
    private static final Signature SINGLE_NEW_INSTANCE = new Signature("newInstance", Constants.TYPE_OBJECT, new Type[]{CALLBACK});
    private static final Signature SET_CALLBACK = new Signature("setCallback", Type.VOID_TYPE, new Type[]{Type.INT_TYPE, CALLBACK});
    private static final Signature GET_CALLBACK = new Signature("getCallback", CALLBACK, new Type[]{Type.INT_TYPE});
    private static final Signature SET_CALLBACKS = new Signature("setCallbacks", Type.VOID_TYPE, new Type[]{CALLBACK_ARRAY});
    private static final Signature GET_CALLBACKS = new Signature("getCallbacks", CALLBACK_ARRAY, new Type[0]);
    private static final Signature THREAD_LOCAL_GET = TypeUtils.parseSignature("Object get()");
    private static final Signature THREAD_LOCAL_SET = TypeUtils.parseSignature("void set(Object)");
    private static final Signature BIND_CALLBACKS = TypeUtils.parseSignature("void CGLIB$BIND_CALLBACKS(Object)");
    private Class[] interfaces;
    private CallbackFilter filter;
    private Callback[] callbacks;
    private Type[] callbackTypes;
    private boolean classOnly;
    private Class superclass;
    private Class[] argumentTypes;
    private Object[] arguments;
    private boolean useFactory = true;
    private Long serialVersionUID;
    private boolean interceptDuringConstruction = true;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Enhancer;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Enhancer$EnhancerKey;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$cglib$proxy$Factory;
    static /* synthetic */ Class array$Lnet$sf$cglib$proxy$Callback;

    public Enhancer() {
        super(SOURCE);
    }

    public void setSuperclass(Class superclass) {
        if (superclass != null && superclass.isInterface()) {
            this.setInterfaces(new Class[]{superclass});
        } else {
            this.superclass = superclass != null && superclass.equals(class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object) ? null : superclass;
        }
    }

    public void setInterfaces(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setCallbackFilter(CallbackFilter filter) {
        this.filter = filter;
    }

    public void setCallback(Callback callback) {
        this.setCallbacks(new Callback[]{callback});
    }

    public void setCallbacks(Callback[] callbacks) {
        if (callbacks != null && callbacks.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbacks = callbacks;
    }

    public void setUseFactory(boolean useFactory) {
        this.useFactory = useFactory;
    }

    public void setInterceptDuringConstruction(boolean interceptDuringConstruction) {
        this.interceptDuringConstruction = interceptDuringConstruction;
    }

    public void setCallbackType(Class callbackType) {
        this.setCallbackTypes(new Class[]{callbackType});
    }

    public void setCallbackTypes(Class[] callbackTypes) {
        if (callbackTypes != null && callbackTypes.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty");
        }
        this.callbackTypes = CallbackInfo.determineTypes(callbackTypes);
    }

    public Object create() {
        this.classOnly = false;
        this.argumentTypes = null;
        return this.createHelper();
    }

    public Object create(Class[] argumentTypes, Object[] arguments) {
        this.classOnly = false;
        if (argumentTypes == null || arguments == null || argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Arguments must be non-null and of equal length");
        }
        this.argumentTypes = argumentTypes;
        this.arguments = arguments;
        return this.createHelper();
    }

    public Class createClass() {
        this.classOnly = true;
        return (Class)this.createHelper();
    }

    public void setSerialVersionUID(Long sUID) {
        this.serialVersionUID = sUID;
    }

    private void validate() {
        if (this.classOnly ^ this.callbacks == null) {
            if (this.classOnly) {
                throw new IllegalStateException("createClass does not accept callbacks");
            }
            throw new IllegalStateException("Callbacks are required");
        }
        if (this.classOnly && this.callbackTypes == null) {
            throw new IllegalStateException("Callback types are required");
        }
        if (this.callbacks != null && this.callbackTypes != null) {
            if (this.callbacks.length != this.callbackTypes.length) {
                throw new IllegalStateException("Lengths of callback and callback types array must be the same");
            }
            Type[] check = CallbackInfo.determineTypes(this.callbacks);
            for (int i2 = 0; i2 < check.length; ++i2) {
                if (check[i2].equals(this.callbackTypes[i2])) continue;
                throw new IllegalStateException("Callback " + check[i2] + " is not assignable to " + this.callbackTypes[i2]);
            }
        } else if (this.callbacks != null) {
            this.callbackTypes = CallbackInfo.determineTypes(this.callbacks);
        }
        if (this.filter == null) {
            if (this.callbackTypes.length > 1) {
                throw new IllegalStateException("Multiple callback types possible but no filter specified");
            }
            this.filter = ALL_ZERO;
        }
        if (this.interfaces != null) {
            for (int i3 = 0; i3 < this.interfaces.length; ++i3) {
                if (this.interfaces[i3] == null) {
                    throw new IllegalStateException("Interfaces cannot be null");
                }
                if (this.interfaces[i3].isInterface()) continue;
                throw new IllegalStateException(this.interfaces[i3] + " is not an interface");
            }
        }
    }

    private Object createHelper() {
        this.validate();
        if (this.superclass != null) {
            this.setNamePrefix(this.superclass.getName());
        } else if (this.interfaces != null) {
            this.setNamePrefix(this.interfaces[ReflectUtils.findPackageProtected(this.interfaces)].getName());
        }
        return super.create(KEY_FACTORY.newInstance(this.superclass, this.interfaces, this.filter, this.callbackTypes, this.useFactory, this.interceptDuringConstruction, this.serialVersionUID));
    }

    protected ClassLoader getDefaultClassLoader() {
        if (this.superclass != null) {
            return this.superclass.getClassLoader();
        }
        if (this.interfaces != null) {
            return this.interfaces[0].getClassLoader();
        }
        return null;
    }

    private Signature rename(Signature sig, int index) {
        return new Signature("CGLIB$" + sig.getName() + "$" + index, sig.getDescriptor());
    }

    public static void getMethods(Class superclass, Class[] interfaces, List methods) {
        Enhancer.getMethods(superclass, interfaces, methods, null, null);
    }

    private static void getMethods(Class superclass, Class[] interfaces, List methods, List interfaceMethods, Set forcePublic) {
        List target;
        ReflectUtils.addAllMethods(superclass, methods);
        List list = target = interfaceMethods != null ? interfaceMethods : methods;
        if (interfaces != null) {
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                if (interfaces[i2] == (class$net$sf$cglib$proxy$Factory == null ? Enhancer.class$("net.sf.cglib.proxy.Factory") : class$net$sf$cglib$proxy$Factory)) continue;
                ReflectUtils.addAllMethods(interfaces[i2], target);
            }
        }
        if (interfaceMethods != null) {
            if (forcePublic != null) {
                forcePublic.addAll(MethodWrapper.createSet(interfaceMethods));
            }
            methods.addAll(interfaceMethods);
        }
        CollectionUtils.filter(methods, new RejectModifierPredicate(8));
        CollectionUtils.filter(methods, new VisibilityPredicate(superclass, true));
        CollectionUtils.filter(methods, new DuplicatesPredicate());
        CollectionUtils.filter(methods, new RejectModifierPredicate(16));
    }

    public void generateClass(ClassVisitor v) throws Exception {
        Class sc;
        Class clazz = this.superclass == null ? (class$java$lang$Object == null ? (class$java$lang$Object = Enhancer.class$("java.lang.Object")) : class$java$lang$Object) : (sc = this.superclass);
        if (TypeUtils.isFinal(sc.getModifiers())) {
            throw new IllegalArgumentException("Cannot subclass final class " + sc);
        }
        ArrayList constructors = new ArrayList(Arrays.asList(sc.getDeclaredConstructors()));
        this.filterConstructors(sc, constructors);
        ArrayList actualMethods = new ArrayList();
        ArrayList interfaceMethods = new ArrayList();
        final HashSet forcePublic = new HashSet();
        Enhancer.getMethods(sc, this.interfaces, actualMethods, interfaceMethods, forcePublic);
        List methods = CollectionUtils.transform(actualMethods, new Transformer(){

            public Object transform(Object value) {
                Method method = (Method)value;
                int modifiers = 0x10 | method.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF;
                if (forcePublic.contains(MethodWrapper.create(method))) {
                    modifiers = modifiers & 0xFFFFFFFB | 1;
                }
                return ReflectUtils.getMethodInfo(method, modifiers);
            }
        });
        ClassEmitter e2 = new ClassEmitter(v);
        e2.begin_class(46, 1, this.getClassName(), Type.getType(sc), this.useFactory ? TypeUtils.add(TypeUtils.getTypes(this.interfaces), FACTORY) : TypeUtils.getTypes(this.interfaces), "<generated>");
        List constructorInfo = CollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        e2.declare_field(2, BOUND_FIELD, Type.BOOLEAN_TYPE, null, null);
        if (!this.interceptDuringConstruction) {
            e2.declare_field(2, CONSTRUCTED_FIELD, Type.BOOLEAN_TYPE, null, null);
        }
        e2.declare_field(26, THREAD_CALLBACKS_FIELD, THREAD_LOCAL, null, null);
        if (this.serialVersionUID != null) {
            e2.declare_field(26, "serialVersionUID", Type.LONG_TYPE, this.serialVersionUID, null);
        }
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            e2.declare_field(2, Enhancer.getCallbackField(i2), this.callbackTypes[i2], null, null);
        }
        this.emitMethods(e2, methods, actualMethods);
        this.emitConstructors(e2, constructorInfo);
        this.emitSetThreadCallbacks(e2);
        this.emitBindCallbacks(e2);
        if (this.useFactory) {
            int[] keys = this.getCallbackKeys();
            this.emitNewInstanceCallbacks(e2);
            this.emitNewInstanceCallback(e2);
            this.emitNewInstanceMultiarg(e2, constructorInfo);
            this.emitGetCallback(e2, keys);
            this.emitSetCallback(e2, keys);
            this.emitGetCallbacks(e2);
            this.emitSetCallbacks(e2);
        }
        e2.end_class();
    }

    protected void filterConstructors(Class sc, List constructors) {
        CollectionUtils.filter(constructors, new VisibilityPredicate(sc, true));
        if (constructors.size() == 0) {
            throw new IllegalArgumentException("No visible constructors in " + sc);
        }
    }

    protected Object firstInstance(Class type) throws Exception {
        if (this.classOnly) {
            return type;
        }
        return this.createUsingReflection(type);
    }

    protected Object nextInstance(Object instance) {
        Class<?> protoclass;
        Class<?> clazz = protoclass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        if (this.classOnly) {
            return protoclass;
        }
        if (instance instanceof Factory) {
            if (this.argumentTypes != null) {
                return ((Factory)instance).newInstance(this.argumentTypes, this.arguments, this.callbacks);
            }
            return ((Factory)instance).newInstance(this.callbacks);
        }
        return this.createUsingReflection(protoclass);
    }

    public static void registerCallbacks(Class generatedClass, Callback[] callbacks) {
        Enhancer.setThreadCallbacks(generatedClass, callbacks);
    }

    public static boolean isEnhanced(Class type) {
        try {
            Enhancer.getCallbacksSetter(type, SET_THREAD_CALLBACKS_NAME);
            return true;
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
    }

    private static void setThreadCallbacks(Class type, Callback[] callbacks) {
        Enhancer.setCallbacksHelper(type, callbacks, SET_THREAD_CALLBACKS_NAME);
    }

    private static void setCallbacksHelper(Class type, Callback[] callbacks, String methodName) {
        try {
            Method setter = Enhancer.getCallbacksSetter(type, methodName);
            setter.invoke(null, new Object[]{callbacks});
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalArgumentException(type + " is not an enhanced class");
        }
        catch (IllegalAccessException e3) {
            throw new CodeGenerationException(e3);
        }
        catch (InvocationTargetException e4) {
            throw new CodeGenerationException(e4);
        }
    }

    private static Method getCallbacksSetter(Class type, String methodName) throws NoSuchMethodException {
        return type.getDeclaredMethod(methodName, array$Lnet$sf$cglib$proxy$Callback == null ? (array$Lnet$sf$cglib$proxy$Callback = Enhancer.class$("[Lnet.sf.cglib.proxy.Callback;")) : array$Lnet$sf$cglib$proxy$Callback);
    }

    private Object createUsingReflection(Class type) {
        Enhancer.setThreadCallbacks(type, this.callbacks);
        Object result = this.argumentTypes != null ? ReflectUtils.newInstance(type, this.argumentTypes, this.arguments) : ReflectUtils.newInstance(type);
        Enhancer.setThreadCallbacks(type, null);
        return result;
    }

    public static Object create(Class type, Callback callback) {
        Enhancer e2 = new Enhancer();
        e2.setSuperclass(type);
        e2.setCallback(callback);
        return e2.create();
    }

    public static Object create(Class superclass, Class[] interfaces, Callback callback) {
        Enhancer e2 = new Enhancer();
        e2.setSuperclass(superclass);
        e2.setInterfaces(interfaces);
        e2.setCallback(callback);
        return e2.create();
    }

    public static Object create(Class superclass, Class[] interfaces, CallbackFilter filter, Callback[] callbacks) {
        Enhancer e2 = new Enhancer();
        e2.setSuperclass(superclass);
        e2.setInterfaces(interfaces);
        e2.setCallbackFilter(filter);
        e2.setCallbacks(callbacks);
        return e2.create();
    }

    private void emitConstructors(ClassEmitter ce, List constructors) {
        boolean seenNull = false;
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            MethodInfo constructor = (MethodInfo)it.next();
            CodeEmitter e2 = EmitUtils.begin_method(ce, constructor, 1);
            e2.load_this();
            e2.dup();
            e2.load_args();
            Signature sig = constructor.getSignature();
            seenNull = seenNull || sig.getDescriptor().equals("()V");
            e2.super_invoke_constructor(sig);
            e2.invoke_static_this(BIND_CALLBACKS);
            if (!this.interceptDuringConstruction) {
                e2.load_this();
                e2.push(1);
                e2.putfield(CONSTRUCTED_FIELD);
            }
            e2.return_value();
            e2.end_method();
        }
        if (!this.classOnly && !seenNull && this.arguments == null) {
            throw new IllegalArgumentException("Superclass has no null constructors but no arguments were given");
        }
    }

    private int[] getCallbackKeys() {
        int[] keys = new int[this.callbackTypes.length];
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            keys[i2] = i2;
        }
        return keys;
    }

    private void emitGetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e2 = ce.begin_method(1, GET_CALLBACK, null, null);
        e2.load_this();
        e2.invoke_static_this(BIND_CALLBACKS);
        e2.load_this();
        e2.load_arg(0);
        e2.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e2.getfield(Enhancer.getCallbackField(key));
                e2.goTo(end);
            }

            public void processDefault() {
                e2.pop();
                e2.aconst_null();
            }
        });
        e2.return_value();
        e2.end_method();
    }

    private void emitSetCallback(ClassEmitter ce, int[] keys) {
        final CodeEmitter e2 = ce.begin_method(1, SET_CALLBACK, null, null);
        e2.load_this();
        e2.load_arg(1);
        e2.load_arg(0);
        e2.process_switch(keys, new ProcessSwitchCallback(){

            public void processCase(int key, Label end) {
                e2.checkcast(Enhancer.this.callbackTypes[key]);
                e2.putfield(Enhancer.getCallbackField(key));
                e2.goTo(end);
            }

            public void processDefault() {
                e2.pop2();
            }
        });
        e2.return_value();
        e2.end_method();
    }

    private void emitSetCallbacks(ClassEmitter ce) {
        CodeEmitter e2 = ce.begin_method(1, SET_CALLBACKS, null, null);
        e2.load_this();
        e2.load_arg(0);
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            e2.dup2();
            e2.aaload(i2);
            e2.checkcast(this.callbackTypes[i2]);
            e2.putfield(Enhancer.getCallbackField(i2));
        }
        e2.return_value();
        e2.end_method();
    }

    private void emitGetCallbacks(ClassEmitter ce) {
        CodeEmitter e2 = ce.begin_method(1, GET_CALLBACKS, null, null);
        e2.load_this();
        e2.invoke_static_this(BIND_CALLBACKS);
        e2.load_this();
        e2.push(this.callbackTypes.length);
        e2.newarray(CALLBACK);
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            e2.dup();
            e2.push(i2);
            e2.load_this();
            e2.getfield(Enhancer.getCallbackField(i2));
            e2.aastore();
        }
        e2.return_value();
        e2.end_method();
    }

    private void emitNewInstanceCallbacks(ClassEmitter ce) {
        CodeEmitter e2 = ce.begin_method(1, NEW_INSTANCE, null, null);
        e2.load_arg(0);
        e2.invoke_static_this(SET_THREAD_CALLBACKS);
        this.emitCommonNewInstance(e2);
    }

    private void emitCommonNewInstance(CodeEmitter e2) {
        e2.new_instance_this();
        e2.dup();
        e2.invoke_constructor_this();
        e2.return_value();
        e2.end_method();
    }

    private void emitNewInstanceCallback(ClassEmitter ce) {
        CodeEmitter e2 = ce.begin_method(1, SINGLE_NEW_INSTANCE, null, null);
        switch (this.callbackTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                e2.push(1);
                e2.newarray(CALLBACK);
                e2.dup();
                e2.push(0);
                e2.load_arg(0);
                e2.aastore();
                e2.invoke_static_this(SET_THREAD_CALLBACKS);
                break;
            }
            default: {
                e2.throw_exception(ILLEGAL_STATE_EXCEPTION, "More than one callback object required");
            }
        }
        this.emitCommonNewInstance(e2);
    }

    private void emitNewInstanceMultiarg(ClassEmitter ce, List constructors) {
        final CodeEmitter e2 = ce.begin_method(1, MULTIARG_NEW_INSTANCE, null, null);
        e2.load_arg(2);
        e2.invoke_static_this(SET_THREAD_CALLBACKS);
        e2.new_instance_this();
        e2.dup();
        e2.load_arg(0);
        EmitUtils.constructor_switch(e2, constructors, new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                MethodInfo constructor = (MethodInfo)key;
                Type[] types = constructor.getSignature().getArgumentTypes();
                for (int i2 = 0; i2 < types.length; ++i2) {
                    e2.load_arg(1);
                    e2.push(i2);
                    e2.aaload();
                    e2.unbox(types[i2]);
                }
                e2.invoke_constructor_this(constructor.getSignature());
                e2.goTo(end);
            }

            public void processDefault() {
                e2.throw_exception(ILLEGAL_ARGUMENT_EXCEPTION, "Constructor not found");
            }
        });
        e2.return_value();
        e2.end_method();
    }

    private void emitMethods(ClassEmitter ce, List methods, List actualMethods) {
        Iterator it2;
        CallbackGenerator[] generators = CallbackInfo.getGenerators(this.callbackTypes);
        HashMap<CallbackGenerator, ArrayList<MethodInfo>> groups = new HashMap<CallbackGenerator, ArrayList<MethodInfo>>();
        final HashMap<MethodInfo, Integer> indexes = new HashMap<MethodInfo, Integer>();
        final HashMap<MethodInfo, Integer> originalModifiers = new HashMap<MethodInfo, Integer>();
        final Map positions = CollectionUtils.getIndexMap(methods);
        Iterator it1 = methods.iterator();
        Iterator iterator = it2 = actualMethods != null ? actualMethods.iterator() : null;
        while (it1.hasNext()) {
            MethodInfo method = (MethodInfo)it1.next();
            Method actualMethod = it2 != null ? (Method)it2.next() : null;
            int index = this.filter.accept(actualMethod);
            if (index >= this.callbackTypes.length) {
                throw new IllegalArgumentException("Callback filter returned an index that is too large: " + index);
            }
            originalModifiers.put(method, new Integer(actualMethod != null ? actualMethod.getModifiers() : method.getModifiers()));
            indexes.put(method, new Integer(index));
            ArrayList<MethodInfo> group = (ArrayList<MethodInfo>)groups.get(generators[index]);
            if (group == null) {
                group = new ArrayList<MethodInfo>(methods.size());
                groups.put(generators[index], group);
            }
            group.add(method);
        }
        HashSet<CallbackGenerator> seenGen = new HashSet<CallbackGenerator>();
        CodeEmitter se = ce.getStaticHook();
        se.new_instance(THREAD_LOCAL);
        se.dup();
        se.invoke_constructor(THREAD_LOCAL, CSTRUCT_NULL);
        se.putfield(THREAD_CALLBACKS_FIELD);
        Object[] state = new Object[1];
        CallbackGenerator.Context context = new CallbackGenerator.Context(){

            public int getOriginalModifiers(MethodInfo method) {
                return (Integer)originalModifiers.get(method);
            }

            public int getIndex(MethodInfo method) {
                return (Integer)indexes.get(method);
            }

            public void emitCallback(CodeEmitter e2, int index) {
                Enhancer.this.emitCurrentCallback(e2, index);
            }

            public Signature getImplSignature(MethodInfo method) {
                return Enhancer.this.rename(method.getSignature(), (Integer)positions.get(method));
            }

            public CodeEmitter beginMethod(ClassEmitter ce, MethodInfo method) {
                CodeEmitter e2 = EmitUtils.begin_method(ce, method);
                if (!Enhancer.this.interceptDuringConstruction && !TypeUtils.isAbstract(method.getModifiers())) {
                    Label constructed = e2.make_label();
                    e2.load_this();
                    e2.getfield(Enhancer.CONSTRUCTED_FIELD);
                    e2.if_jump(154, constructed);
                    e2.load_this();
                    e2.load_args();
                    e2.super_invoke();
                    e2.return_value();
                    e2.mark(constructed);
                }
                return e2;
            }
        };
        for (int i2 = 0; i2 < this.callbackTypes.length; ++i2) {
            CallbackGenerator gen = generators[i2];
            if (seenGen.contains(gen)) continue;
            seenGen.add(gen);
            List fmethods = (List)groups.get(gen);
            if (fmethods == null) continue;
            try {
                gen.generate(ce, context, fmethods);
                gen.generateStatic(se, context, fmethods);
                continue;
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new CodeGenerationException(x);
            }
        }
        se.return_value();
        se.end_method();
    }

    private void emitSetThreadCallbacks(ClassEmitter ce) {
        CodeEmitter e2 = ce.begin_method(9, SET_THREAD_CALLBACKS, null, null);
        e2.getfield(THREAD_CALLBACKS_FIELD);
        e2.load_arg(0);
        e2.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_SET);
        e2.return_value();
        e2.end_method();
    }

    private void emitCurrentCallback(CodeEmitter e2, int index) {
        e2.load_this();
        e2.getfield(Enhancer.getCallbackField(index));
        e2.dup();
        Label end = e2.make_label();
        e2.ifnonnull(end);
        e2.pop();
        e2.load_this();
        e2.invoke_static_this(BIND_CALLBACKS);
        e2.load_this();
        e2.getfield(Enhancer.getCallbackField(index));
        e2.mark(end);
    }

    private void emitBindCallbacks(ClassEmitter ce) {
        CodeEmitter e2 = ce.begin_method(26, BIND_CALLBACKS, null, null);
        Local me = e2.make_local();
        e2.load_arg(0);
        e2.checkcast_this();
        e2.store_local(me);
        Label end = e2.make_label();
        e2.load_local(me);
        e2.getfield(BOUND_FIELD);
        e2.if_jump(154, end);
        e2.load_local(me);
        e2.push(1);
        e2.putfield(BOUND_FIELD);
        e2.getfield(THREAD_CALLBACKS_FIELD);
        e2.invoke_virtual(THREAD_LOCAL, THREAD_LOCAL_GET);
        e2.dup();
        Label found_callback = e2.make_label();
        e2.ifnonnull(found_callback);
        e2.pop();
        e2.goTo(end);
        e2.mark(found_callback);
        e2.checkcast(CALLBACK_ARRAY);
        e2.load_local(me);
        e2.swap();
        for (int i2 = this.callbackTypes.length - 1; i2 >= 0; --i2) {
            if (i2 != 0) {
                e2.dup2();
            }
            e2.aaload(i2);
            e2.checkcast(this.callbackTypes[i2]);
            e2.putfield(Enhancer.getCallbackField(i2));
        }
        e2.mark(end);
        e2.return_value();
        e2.end_method();
    }

    private static String getCallbackField(int index) {
        return "CGLIB$CALLBACK_" + index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface EnhancerKey {
        public Object newInstance(Class var1, Class[] var2, CallbackFilter var3, Type[] var4, boolean var5, boolean var6, Long var7);
    }
}

