/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ObjectSwitchCallback;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.proxy.CallbackGenerator;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String EMPTY_ARGS_NAME = "CGLIB$emptyArgs";
    static final String FIND_PROXY_NAME = "CGLIB$findMethodProxy";
    static final Class[] FIND_PROXY_TYPES = new Class[]{class$net$sf$cglib$core$Signature == null ? (class$net$sf$cglib$core$Signature = MethodInterceptorGenerator.class$("net.sf.cglib.core.Signature")) : class$net$sf$cglib$core$Signature};
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType("AbstractMethodError");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Type METHOD_PROXY = TypeUtils.parseType("net.sf.cglib.proxy.MethodProxy");
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType("net.sf.cglib.proxy.MethodInterceptor");
    private static final Signature GET_DECLARING_CLASS = TypeUtils.parseSignature("Class getDeclaringClass()");
    private static final Signature GET_CLASS_LOADER = TypeUtils.parseSignature("ClassLoader getClassLoader()");
    private static final Signature MAKE_PROXY = new Signature("create", METHOD_PROXY, new Type[]{Constants.TYPE_CLASS_LOADER, Constants.TYPE_CLASS, Constants.TYPE_CLASS, Constants.TYPE_STRING, Constants.TYPE_STRING, Constants.TYPE_STRING});
    private static final Signature INTERCEPT = new Signature("intercept", Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_OBJECT, METHOD, Constants.TYPE_OBJECT_ARRAY, METHOD_PROXY});
    private static final Signature FIND_PROXY = new Signature("CGLIB$findMethodProxy", METHOD_PROXY, new Type[]{Constants.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    static /* synthetic */ Class class$net$sf$cglib$core$Signature;

    MethodInterceptorGenerator() {
    }

    private String getMethodField(Signature impl) {
        return impl.getName() + "$Method";
    }

    private String getMethodProxyField(Signature impl) {
        return impl.getName() + "$Proxy";
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods) {
        HashMap<String, String> sigMap = new HashMap<String, String>();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            Signature impl = context.getImplSignature(method);
            String methodField = this.getMethodField(impl);
            String methodProxyField = this.getMethodProxyField(impl);
            sigMap.put(method.getSignature().toString(), methodProxyField);
            ce.declare_field(26, methodField, METHOD, null, null);
            ce.declare_field(26, methodProxyField, METHOD_PROXY, null, null);
            ce.declare_field(26, EMPTY_ARGS_NAME, Constants.TYPE_OBJECT_ARRAY, null, null);
            CodeEmitter e2 = ce.begin_method(16, impl, method.getExceptionTypes(), null);
            if (TypeUtils.isAbstract(method.getModifiers())) {
                e2.throw_exception(ABSTRACT_METHOD_ERROR, method.toString() + " is abstract");
            } else {
                e2.load_this();
                e2.load_args();
                e2.super_invoke(method.getSignature());
            }
            e2.return_value();
            e2.end_method();
            e2 = context.beginMethod(ce, method);
            Label nullInterceptor = e2.make_label();
            context.emitCallback(e2, context.getIndex(method));
            e2.dup();
            e2.ifnull(nullInterceptor);
            e2.load_this();
            e2.getfield(methodField);
            if (method.getSignature().getArgumentTypes().length == 0) {
                e2.getfield(EMPTY_ARGS_NAME);
            } else {
                e2.create_arg_array();
            }
            e2.getfield(methodProxyField);
            e2.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            e2.unbox_or_zero(method.getSignature().getReturnType());
            e2.return_value();
            e2.mark(nullInterceptor);
            e2.load_this();
            e2.load_args();
            e2.super_invoke(method.getSignature());
            e2.return_value();
            e2.end_method();
        }
        this.generateFindProxy(ce, sigMap);
    }

    public void generateStatic(CodeEmitter e2, CallbackGenerator.Context context, List methods) {
        Local thisclass = e2.make_local();
        EmitUtils.load_class_this(e2);
        e2.dup();
        e2.store_local(thisclass);
        e2.invoke_virtual(Constants.TYPE_CLASS, GET_CLASS_LOADER);
        e2.push(0);
        e2.newarray();
        e2.putfield(EMPTY_ARGS_NAME);
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            e2.dup();
            MethodInfo method = (MethodInfo)it.next();
            Signature impl = context.getImplSignature(method);
            EmitUtils.load_method(e2, method);
            e2.dup();
            e2.putfield(this.getMethodField(impl));
            Signature sig = method.getSignature();
            e2.invoke_virtual(METHOD, GET_DECLARING_CLASS);
            e2.load_local(thisclass);
            e2.push(sig.getDescriptor());
            e2.push(sig.getName());
            e2.push(impl.getName());
            e2.invoke_static(METHOD_PROXY, MAKE_PROXY);
            e2.putfield(this.getMethodProxyField(impl));
        }
    }

    public void generateFindProxy(ClassEmitter ce, final Map sigMap) {
        final CodeEmitter e2 = ce.begin_method(9, FIND_PROXY, null, null);
        e2.load_arg(0);
        e2.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            public void processCase(Object key, Label end) {
                e2.getfield((String)sigMap.get(key));
                e2.return_value();
            }

            public void processDefault() {
                e2.aconst_null();
                e2.return_value();
            }
        };
        EmitUtils.string_switch(e2, sigMap.keySet().toArray(new String[0]), 1, callback);
        e2.end_method();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

