/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.ObjectExistsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configuration {
    private DiskStore diskStore;
    private DefaultCache defaultCache;
    private Map caches = new HashMap();
    static /* synthetic */ Class class$net$sf$ehcache$config$Configuration$DiskStore;

    public void addDiskStore(DiskStore diskStore) throws ObjectExistsException {
        if (this.diskStore != null) {
            throw new ObjectExistsException("The Disk Store has already been configured");
        }
        this.diskStore = diskStore;
    }

    public void addDefaultCache(DefaultCache defaultCache) throws ObjectExistsException {
        if (this.defaultCache != null) {
            throw new ObjectExistsException("The Default Cache has already been configured");
        }
        this.defaultCache = defaultCache;
    }

    public void addCache(Cache cache) throws ObjectExistsException {
        if (this.caches.get(cache.name) != null) {
            throw new ObjectExistsException("Cannot create cache: " + cache.name + " with the same name as an existing one.");
        }
        if (cache.name.equalsIgnoreCase("default")) {
            throw new ObjectExistsException("The Default Cache has already been configured");
        }
        this.caches.put(cache.name, cache);
    }

    public String getDiskCachePath() {
        if (this.diskStore != null) {
            return this.diskStore.getPath();
        }
        return null;
    }

    public net.sf.ehcache.Cache getDefaultCache() throws CacheException {
        if (this.defaultCache == null) {
            throw new CacheException("Illegal configuration. No default cache is configured.");
        }
        return this.defaultCache.toCache();
    }

    public Set getCacheKeySet() {
        return this.caches.keySet();
    }

    public net.sf.ehcache.Cache getCache(String name) {
        Cache cache = (Cache)this.caches.get(name);
        return cache.toCache();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DefaultCache
    extends Cache {
        private net.sf.ehcache.Cache toCache() {
            return new net.sf.ehcache.Cache("default", this.maxElementsInMemory, this.overflowToDisk, this.eternal, this.timeToLiveSeconds, this.timeToIdleSeconds, this.diskPersistent, this.diskExpiryThreadIntervalSeconds);
        }
    }

    public static class Cache {
        protected String name;
        protected int maxElementsInMemory;
        protected boolean eternal;
        protected int timeToIdleSeconds;
        protected int timeToLiveSeconds;
        protected boolean overflowToDisk;
        protected boolean diskPersistent;
        protected long diskExpiryThreadIntervalSeconds;

        public void setName(String name) {
            this.name = name;
        }

        public void setMaxElementsInMemory(int maxElementsInMemory) {
            this.maxElementsInMemory = maxElementsInMemory;
        }

        public void setEternal(boolean eternal) {
            this.eternal = eternal;
        }

        public void setTimeToIdleSeconds(int timeToIdleSeconds) {
            this.timeToIdleSeconds = timeToIdleSeconds;
        }

        public void setTimeToLiveSeconds(int timeToLiveSeconds) {
            this.timeToLiveSeconds = timeToLiveSeconds;
        }

        public void setOverflowToDisk(boolean overflowToDisk) {
            this.overflowToDisk = overflowToDisk;
        }

        public void setDiskPersistent(boolean diskPersistent) {
            this.diskPersistent = diskPersistent;
        }

        public void setDiskExpiryThreadIntervalSeconds(int diskExpiryThreadIntervalSeconds) {
            this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
        }

        private net.sf.ehcache.Cache toCache() {
            return new net.sf.ehcache.Cache(this.name, this.maxElementsInMemory, this.overflowToDisk, this.eternal, this.timeToLiveSeconds, this.timeToIdleSeconds, this.diskPersistent, this.diskExpiryThreadIntervalSeconds);
        }
    }

    public static class DiskStore {
        private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$config$Configuration$DiskStore == null ? (class$net$sf$ehcache$config$Configuration$DiskStore = Configuration.class$("net.sf.ehcache.config.Configuration$DiskStore")) : class$net$sf$ehcache$config$Configuration$DiskStore).getName());
        private String path;

        public void setPath(String path) {
            String translatedPath = null;
            translatedPath = path.equals("user.home") ? System.getProperty("user.home") : (path.equals("user.dir") ? System.getProperty("user.dir") : (path.equals("java.io.tmpdir") ? System.getProperty("java.io.tmpdir") : path));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Disk Store Path: " + translatedPath);
            }
            this.path = translatedPath;
        }

        private String getPath() {
            return this.path;
        }
    }
}

