/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignField;

public abstract class JRAbstractBeanDataSourceProvider
implements JRDataSourceProvider {
    private Class beanClass;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public JRAbstractBeanDataSourceProvider(Class beanClass) {
        if (beanClass == null) {
            throw new NullPointerException("beanClass must not be null");
        }
        this.beanClass = beanClass;
    }

    public boolean supportsGetFieldsOperation() {
        return true;
    }

    public JRField[] getFields(JasperReport report) throws JRException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.beanClass);
        }
        catch (IntrospectionException e2) {
            throw new JRException(e2);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>(descriptors.length);
            for (int i2 = 0; i2 < descriptors.length; ++i2) {
                PropertyDescriptor descriptor = descriptors[i2];
                if (descriptor instanceof IndexedPropertyDescriptor || descriptor.getReadMethod() == null) continue;
                JRDesignField field = new JRDesignField();
                field.setValueClassName(JRAbstractBeanDataSourceProvider.normalizeClass(descriptor.getPropertyType()).getName());
                field.setName(descriptor.getName());
                fields.add(field);
            }
            return fields.toArray(new JRField[fields.size()]);
        }
        return new JRField[0];
    }

    private static Class normalizeClass(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JRAbstractBeanDataSourceProvider.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            if (clazz == Byte.TYPE) {
                return class$java$lang$Byte == null ? (class$java$lang$Byte = JRAbstractBeanDataSourceProvider.class$("java.lang.Byte")) : class$java$lang$Byte;
            }
            if (clazz == Character.TYPE) {
                return class$java$lang$Character == null ? (class$java$lang$Character = JRAbstractBeanDataSourceProvider.class$("java.lang.Character")) : class$java$lang$Character;
            }
            if (clazz == Short.TYPE) {
                return class$java$lang$Short == null ? (class$java$lang$Short = JRAbstractBeanDataSourceProvider.class$("java.lang.Short")) : class$java$lang$Short;
            }
            if (clazz == Integer.TYPE) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = JRAbstractBeanDataSourceProvider.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (clazz == Long.TYPE) {
                return class$java$lang$Long == null ? (class$java$lang$Long = JRAbstractBeanDataSourceProvider.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (clazz == Float.TYPE) {
                return class$java$lang$Float == null ? (class$java$lang$Float = JRAbstractBeanDataSourceProvider.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (clazz == Double.TYPE) {
                return class$java$lang$Double == null ? (class$java$lang$Double = JRAbstractBeanDataSourceProvider.class$("java.lang.Double")) : class$java$lang$Double;
            }
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

