/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.engine.query.JRJpaQueryExecuter;

public class JRJpaDataSource
extends JRAbstractBeanDataSource
implements JRRewindableDataSource {
    private static final String MAPPING_INDEX_PREFIX = "COLUMN_";
    private static final int MAPPING_INDEX_PREFIX_LENGTH = "COLUMN_".length();
    private static final String MAPPING_INDEX_PROPERTY_SEP = ".";
    private static final int MAPPING_INDEX_PROPERTY_SEP_LENGTH = ".".length();
    private final JRJpaQueryExecuter queryExecuter;
    private final int pageSize;
    private int pageCount;
    private boolean nextPage;
    private List returnValues;
    private Iterator iterator;
    protected Object currentRow;
    private Map fieldValueReaders;

    public JRJpaDataSource(JRJpaQueryExecuter queryExecuter, int pageSize) {
        super(true);
        this.queryExecuter = queryExecuter;
        this.pageSize = pageSize;
        this.fieldValueReaders = new HashMap();
        this.pageCount = 0;
        this.fetchPage();
    }

    protected void fetchPage() {
        if (this.pageSize <= 0) {
            this.returnValues = this.queryExecuter.getResultList();
            this.nextPage = false;
        } else {
            this.returnValues = this.queryExecuter.getResultList(this.pageCount * this.pageSize, this.pageSize);
            this.nextPage = this.returnValues.size() == this.pageSize;
        }
        ++this.pageCount;
        this.initIterator();
    }

    public boolean next() {
        if (this.iterator == null) {
            return false;
        }
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext && this.nextPage) {
            this.fetchPage();
            boolean bl = hasNext = this.iterator != null && this.iterator.hasNext();
        }
        if (hasNext) {
            this.currentRow = this.iterator.next();
        }
        return hasNext;
    }

    public void moveFirst() {
        if (this.pageCount == 1) {
            this.initIterator();
        } else {
            this.pageCount = 0;
            this.fetchPage();
        }
    }

    private void initIterator() {
        this.iterator = this.returnValues == null ? null : this.returnValues.iterator();
    }

    public Object getFieldValue(JRField field) throws JRException {
        FieldValueReader reader = this.getFieldValueReader(field);
        return reader.getValue();
    }

    protected FieldValueReader getFieldValueReader(JRField field) {
        FieldValueReader reader = (FieldValueReader)this.fieldValueReaders.get(field.getName());
        if (reader == null) {
            String mapping = this.getPropertyName(field);
            reader = this.createReader(mapping);
            this.fieldValueReaders.put(field.getName(), reader);
        }
        return reader;
    }

    private FieldValueReader createReader(String mapping) {
        FieldValueReader reader = null;
        if (mapping.startsWith(MAPPING_INDEX_PREFIX)) {
            int propertySepIdx = mapping.indexOf(MAPPING_INDEX_PROPERTY_SEP, MAPPING_INDEX_PREFIX_LENGTH + 1);
            if (propertySepIdx < 0) {
                String indexStr = mapping.substring(MAPPING_INDEX_PREFIX_LENGTH);
                try {
                    int index = Integer.parseInt(indexStr);
                    reader = new IndexReader(index - 1);
                }
                catch (NumberFormatException e2) {}
            } else {
                String indexStr = mapping.substring(MAPPING_INDEX_PREFIX_LENGTH, propertySepIdx);
                try {
                    int index = Integer.parseInt(indexStr);
                    String property = mapping.substring(propertySepIdx + MAPPING_INDEX_PROPERTY_SEP_LENGTH);
                    reader = new IndexPropertyReader(index - 1, property);
                }
                catch (NumberFormatException e3) {
                    // empty catch block
                }
            }
        }
        if (reader == null) {
            reader = new PropertyReader(mapping);
        }
        return reader;
    }

    protected class IndexPropertyReader
    implements FieldValueReader {
        private final int position;
        private final String property;

        public IndexPropertyReader(int position, String property) {
            this.position = position;
            this.property = property;
        }

        public Object getValue() throws JRException {
            Object[] values = (Object[])JRJpaDataSource.this.currentRow;
            if (this.position < 0 || this.position >= values.length) {
                throw new JRRuntimeException("Index " + this.position + " out of bounds for query result of length " + values.length);
            }
            return JRAbstractBeanDataSource.getBeanProperty(values[this.position], this.property);
        }
    }

    protected class IndexReader
    implements FieldValueReader {
        private final int position;

        public IndexReader(int position) {
            this.position = position;
        }

        public Object getValue() throws JRException {
            Object[] values = (Object[])JRJpaDataSource.this.currentRow;
            if (this.position < 0 || this.position >= values.length) {
                throw new JRRuntimeException("Index " + this.position + " out of bounds for query result of length " + values.length);
            }
            return values[this.position];
        }
    }

    protected class PropertyReader
    implements FieldValueReader {
        private final String property;

        public PropertyReader(String property) {
            this.property = property;
        }

        public Object getValue() throws JRException {
            return JRAbstractBeanDataSource.getBeanProperty(JRJpaDataSource.this.currentRow, this.property);
        }
    }

    protected static interface FieldValueReader {
        public Object getValue() throws JRException;
    }
}

