/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.FontKey;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.PdfFont;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRPdfExporter
extends JRAbstractExporter {
    public static final String PDF_FORCE_SVG_SHAPES = "net.sf.jasperreports.export.pdf.force.svg.shapes";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered = false;
    protected Document document = null;
    protected PdfContentByte pdfContentByte = null;
    protected Document imageTesterDocument = null;
    protected PdfContentByte imageTesterPdfContentByte = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected boolean isCreatingBatchModeBookmarks = false;
    protected boolean isCompressed = false;
    protected boolean isEncrypted = false;
    protected boolean is128BitKey = false;
    protected String userPassword = null;
    protected String ownerPassword = null;
    protected int permissions = 0;
    protected Character pdfVersion = null;
    protected Map loadedImagesMap = null;
    protected Image pxImage = null;
    private BookmarkStack bookmarkStack = null;
    private Map fontMap = null;
    private boolean forceSvgShapes = true;
    private SplitCharacter splitCharacter;
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;
    private String pdfJavaScript;

    protected Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance(JRLoader.loadBytesFromLocation("net/sf/jasperreports/engine/images/pixel.GIF", null));
            }
            catch (Exception e2) {
                throw new JRRuntimeException(e2);
            }
        }
        return this.pxImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block23: {
            JRPdfExporter.registerFonts();
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                Boolean is128BitKeyParameter;
                Boolean isEncryptedParameter;
                Boolean isCompressedParameter;
                Boolean isCreatingBatchModeBookmarksParameter;
                this.setExportContext();
                this.setInput();
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                if ((isCreatingBatchModeBookmarksParameter = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS)) != null) {
                    this.isCreatingBatchModeBookmarks = isCreatingBatchModeBookmarksParameter;
                }
                if ((isCompressedParameter = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_COMPRESSED)) != null) {
                    this.isCompressed = isCompressedParameter;
                }
                if ((isEncryptedParameter = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_ENCRYPTED)) != null) {
                    this.isEncrypted = isEncryptedParameter;
                }
                if ((is128BitKeyParameter = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_128_BIT_KEY)) != null) {
                    this.is128BitKey = is128BitKeyParameter;
                }
                this.userPassword = (String)this.parameters.get(JRPdfExporterParameter.USER_PASSWORD);
                this.ownerPassword = (String)this.parameters.get(JRPdfExporterParameter.OWNER_PASSWORD);
                Integer permissionsParameter = (Integer)this.parameters.get(JRPdfExporterParameter.PERMISSIONS);
                if (permissionsParameter != null) {
                    this.permissions = permissionsParameter;
                }
                this.pdfVersion = (Character)this.parameters.get(JRPdfExporterParameter.PDF_VERSION);
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setForceSvgShapes();
                this.setSplitCharacter();
                this.setHyperlinkProducerFactory();
                this.pdfJavaScript = (String)this.parameters.get(JRPdfExporterParameter.PDF_JAVASCRIPT);
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    this.exportReportToStream(os);
                    break block23;
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e2) {
                    throw new JRException("Error trying to export to file : " + destFile, e2);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e3) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setForceSvgShapes() {
        Boolean forceSvgShapesParam = (Boolean)this.parameters.get(JRPdfExporterParameter.FORCE_SVG_SHAPES);
        this.forceSvgShapes = forceSvgShapesParam == null ? JRProperties.getBooleanProperty(PDF_FORCE_SVG_SHAPES) : forceSvgShapesParam;
    }

    protected void setSplitCharacter() {
        Boolean useFillSplitCharacterParam = (Boolean)this.parameters.get(JRPdfExporterParameter.FORCE_LINEBREAK_POLICY);
        boolean useFillSplitCharacter = useFillSplitCharacterParam == null ? JRProperties.getBooleanProperty("net.sf.jasperreports.export.pdf.force.linebreak.policy") : useFillSplitCharacterParam;
        if (useFillSplitCharacter) {
            this.splitCharacter = new BreakIteratorSplitCharacter();
        }
    }

    protected void setHyperlinkProducerFactory() {
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.document = new Document(new Rectangle(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        boolean closeDocuments = true;
        try {
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            PdfWriter pdfWriter = PdfWriter.getInstance(this.document, os);
            pdfWriter.setCloseStream(false);
            if (this.pdfVersion != null) {
                pdfWriter.setPdfVersion(this.pdfVersion.charValue());
            }
            if (this.isCompressed) {
                pdfWriter.setFullCompression();
            }
            if (this.isEncrypted) {
                pdfWriter.setEncryption(this.is128BitKey, this.userPassword, this.ownerPassword, this.permissions);
            }
            if ((title = (String)this.parameters.get(JRPdfExporterParameter.METADATA_TITLE)) != null) {
                this.document.addTitle(title);
            }
            if ((author = (String)this.parameters.get(JRPdfExporterParameter.METADATA_AUTHOR)) != null) {
                this.document.addAuthor(author);
            }
            if ((subject = (String)this.parameters.get(JRPdfExporterParameter.METADATA_SUBJECT)) != null) {
                this.document.addSubject(subject);
            }
            if ((keywords = (String)this.parameters.get(JRPdfExporterParameter.METADATA_KEYWORDS)) != null) {
                this.document.addKeywords(keywords);
            }
            if ((creator = (String)this.parameters.get(JRPdfExporterParameter.METADATA_CREATOR)) != null) {
                this.document.addCreator(creator);
            } else {
                this.document.addCreator("JasperReports (" + this.jasperPrint.getName() + ")");
            }
            this.document.open();
            if (this.pdfJavaScript != null) {
                pdfWriter.addJavaScript(this.pdfJavaScript);
            }
            this.pdfContentByte = pdfWriter.getDirectContent();
            this.initBookmarks();
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance(this.imageTesterDocument, new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.loadedImagesMap = new HashMap();
                this.document.setPageSize(new Rectangle(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
                List pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (this.isModeBatch) {
                        this.document.newPage();
                        if (this.isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                        this.startPageIndex = 0;
                        this.endPageIndex = pages.size() - 1;
                    }
                    Chunk chunk = null;
                    ColumnText colText = null;
                    JRPrintPage page = null;
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        page = (JRPrintPage)pages.get(pageIndex);
                        this.document.newPage();
                        this.pdfContentByte = pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        chunk = new Chunk(" ");
                        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
                        colText = new ColumnText(this.pdfContentByte);
                        colText.setSimpleColumn(new Phrase(chunk), 0.0f, this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
                        colText.go();
                        this.exportPage(page);
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            closeDocuments = false;
            this.document.close();
            this.imageTesterDocument.close();
        }
        catch (DocumentException e2) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), e2);
        }
        catch (IOException e3) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), e3);
        }
        finally {
            if (closeDocuments) {
                try {
                    this.document.close();
                }
                catch (Throwable e4) {}
                try {
                    this.imageTesterDocument.close();
                }
                catch (Throwable e5) {}
            }
        }
    }

    protected void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        List elements = page.getElements();
        this.exportElements(elements);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection elements) throws DocumentException, IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                JRPrintElement element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (!(element instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        if (line.getPen() != 0) {
            this.pdfContentByte.setRGBColorStroke(line.getForecolor().getRed(), line.getForecolor().getGreen(), line.getForecolor().getBlue());
            switch (line.getPen()) {
                case 4: {
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                    break;
                }
                case 3: {
                    this.pdfContentByte.setLineWidth(4.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 2: {
                    this.pdfContentByte.setLineWidth(2.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 0: {
                    break;
                }
                case 5: {
                    this.pdfContentByte.setLineWidth(0.5f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                default: {
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                }
            }
            if (line.getDirection() == 1) {
                this.pdfContentByte.moveTo(line.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY());
                this.pdfContentByte.lineTo(line.getX() + this.getOffsetX() + line.getWidth() - 1, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight() + 1);
            } else {
                this.pdfContentByte.moveTo(line.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY() - line.getHeight() + 1);
                this.pdfContentByte.lineTo(line.getX() + this.getOffsetX() + line.getWidth() - 1, this.jasperPrint.getPageHeight() - line.getY() - this.getOffsetY());
            }
            this.pdfContentByte.stroke();
            this.pdfContentByte.setLineDash(0.0f);
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContentByte.setRGBColorStroke(rectangle.getForecolor().getRed(), rectangle.getForecolor().getGreen(), rectangle.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        float borderCorrection = this.prepareGraphicElement(rectangle);
        if (rectangle.getMode() == 1) {
            this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) - borderCorrection + 1.0f, (float)rectangle.getWidth() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getHeight() + 2.0f * borderCorrection - 1.0f, rectangle.getRadius());
            if (rectangle.getPen() == 4) {
                this.pdfContentByte.fill();
                this.pdfContentByte.roundRectangle(rectangle.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight() + 1, rectangle.getWidth() - 1, rectangle.getHeight() - 1, rectangle.getRadius());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.fillStroke();
            }
        } else if (rectangle.getPen() != 0) {
            this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.getOffsetY() - rectangle.getHeight()) - borderCorrection + 1.0f, (float)rectangle.getWidth() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getHeight() + 2.0f * borderCorrection - 1.0f, rectangle.getRadius());
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected float prepareGraphicElement(JRPrintGraphicElement element) {
        float borderCorrection = 0.0f;
        switch (element.getPen()) {
            case 4: {
                borderCorrection = element.getMode() == 1 ? 0.5f : 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                borderCorrection = 0.5f;
                this.pdfContentByte.setLineWidth(4.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                borderCorrection = 0.5f;
                this.pdfContentByte.setLineWidth(2.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                this.pdfContentByte.setLineWidth(0.5f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                this.pdfContentByte.setLineWidth(0.0f);
                this.pdfContentByte.setLineDash(0.0f);
                this.pdfContentByte.setRGBColorStroke(element.getBackcolor().getRed(), element.getBackcolor().getGreen(), element.getBackcolor().getBlue());
                break;
            }
            default: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(0.0f);
            }
        }
        return borderCorrection;
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContentByte.setRGBColorStroke(ellipse.getForecolor().getRed(), ellipse.getForecolor().getGreen(), ellipse.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
        float borderCorrection = this.prepareGraphicElement(ellipse);
        if (ellipse.getMode() == 1) {
            this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) - borderCorrection + 1.0f, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) + borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) + borderCorrection);
            if (ellipse.getPen() == 4) {
                this.pdfContentByte.fill();
                this.pdfContentByte.ellipse(ellipse.getX() + this.getOffsetX(), this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight() + 1, ellipse.getX() + this.getOffsetX() + ellipse.getWidth() - 1, this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.fillStroke();
            }
        } else if (ellipse.getPen() != 0) {
            this.pdfContentByte.ellipse((float)(ellipse.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY() - ellipse.getHeight()) - borderCorrection + 1.0f, (float)(ellipse.getX() + this.getOffsetX() + ellipse.getWidth()) + borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.getOffsetY()) + borderCorrection);
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected void exportImage(JRPrintImage printImage) throws DocumentException, IOException, JRException {
        this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
        if (printImage.getMode() == 1) {
            float borderCorrection = 0.5f;
            this.pdfContentByte.setRGBColorStroke(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(0.1f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)(printImage.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - printImage.getY() - this.getOffsetY()) + borderCorrection, (float)printImage.getWidth() + 2.0f * borderCorrection - 1.0f, (float)(-printImage.getHeight()) - 2.0f * borderCorrection + 1.0f);
            this.pdfContentByte.fillStroke();
        }
        int topPadding = printImage.getTopPadding();
        int leftPadding = printImage.getLeftPadding();
        int bottomPadding = printImage.getBottomPadding();
        int rightPadding = printImage.getRightPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        JRRenderable renderer = printImage.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            int xoffset = 0;
            int yoffset = 0;
            Chunk chunk = null;
            float scaledWidth = availableImageWidth;
            float scaledHeight = availableImageHeight;
            if (renderer.getType() == 0) {
                Image image = null;
                float xalignFactor = this.getXAlignFactor(printImage);
                float yalignFactor = this.getYAlignFactor(printImage);
                switch (printImage.getScaleImage()) {
                    case 1: {
                        int normalWidth = availableImageWidth;
                        int normalHeight = availableImageHeight;
                        Dimension2D dimension = renderer.getDimension();
                        if (dimension != null) {
                            normalWidth = (int)dimension.getWidth();
                            normalHeight = (int)dimension.getHeight();
                        }
                        xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        int minWidth = Math.min(normalWidth, availableImageWidth);
                        int minHeight = Math.min(normalHeight, availableImageHeight);
                        BufferedImage bi = new BufferedImage(minWidth, minHeight, 2);
                        Graphics2D g2 = bi.createGraphics();
                        if (printImage.getMode() == 1) {
                            g2.setColor(printImage.getBackcolor());
                            g2.fillRect(0, 0, minWidth, minHeight);
                        }
                        renderer.render(g2, new java.awt.Rectangle(xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, normalWidth, normalHeight));
                        g2.dispose();
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        yoffset = yoffset < 0 ? 0 : yoffset;
                        image = Image.getInstance(bi, null);
                        break;
                    }
                    case 2: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = (Image)this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance(renderer.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e2) {
                                java.awt.Image awtImage = JRImageRenderer.getInstance(renderer.getImageData(), printImage.getOnErrorType()).getImage();
                                image = Image.getInstance(awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleAbsolute(availableImageWidth, availableImageHeight);
                        break;
                    }
                    default: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = (Image)this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance(renderer.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e3) {
                                java.awt.Image awtImage = JRImageRenderer.getInstance(renderer.getImageData(), printImage.getOnErrorType()).getImage();
                                image = Image.getInstance(awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleToFit(availableImageWidth, availableImageHeight);
                        xoffset = (int)(xalignFactor * ((float)availableImageWidth - image.plainWidth()));
                        yoffset = (int)(yalignFactor * ((float)availableImageHeight - image.plainHeight()));
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        yoffset = yoffset < 0 ? 0 : yoffset;
                    }
                }
                chunk = new Chunk(image, -0.5f, 0.5f);
                scaledWidth = image.scaledWidth();
                scaledHeight = image.scaledHeight();
            } else {
                Graphics2D g3;
                double normalWidth = availableImageWidth;
                double normalHeight = availableImageHeight;
                Dimension2D dimension = renderer.getDimension();
                if (dimension != null) {
                    float xalignFactor = this.getXAlignFactor(printImage);
                    float yalignFactor = this.getYAlignFactor(printImage);
                    switch (printImage.getScaleImage()) {
                        case 1: {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - normalWidth));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - normalHeight));
                            break;
                        }
                        case 2: {
                            xoffset = 0;
                            yoffset = 0;
                            break;
                        }
                        default: {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                            double ratioX = (double)availableImageWidth / normalWidth;
                            double ratioY = (double)availableImageHeight / normalHeight;
                            double ratio = ratioX < ratioY ? ratioX : ratioY;
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - (normalWidth *= ratio)));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - (normalHeight *= ratio)));
                            break;
                        }
                    }
                }
                PdfTemplate template = this.pdfContentByte.createTemplate(availableImageWidth, availableImageHeight);
                Graphics2D graphics2D = g3 = this.forceSvgShapes ? template.createGraphicsShapes(availableImageWidth, availableImageHeight) : template.createGraphics(availableImageWidth, availableImageHeight, new LocalFontMapper());
                if (printImage.getMode() == 1) {
                    g3.setColor(printImage.getBackcolor());
                    g3.fillRect(0, 0, normalWidth <= (double)availableImageWidth ? (int)normalWidth : availableImageWidth, normalHeight <= (double)availableImageHeight ? (int)normalHeight : availableImageHeight);
                }
                Rectangle2D.Double rectangle = new Rectangle2D.Double(xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, normalWidth, normalHeight);
                renderer.render(g3, rectangle);
                g3.dispose();
                xoffset = xoffset < 0 ? 0 : xoffset;
                yoffset = yoffset < 0 ? 0 : yoffset;
                this.pdfContentByte.saveState();
                this.pdfContentByte.addTemplate(template, printImage.getX() + this.getOffsetX() + xoffset, this.jasperPrint.getPageHeight() - printImage.getY() - this.getOffsetY() - availableImageHeight - yoffset);
                this.pdfContentByte.restoreState();
                Image image = this.getPxImage();
                image.scaleAbsolute(availableImageWidth, availableImageHeight);
                chunk = new Chunk(image, 0.0f, 0.0f);
            }
            this.setAnchor(chunk, printImage, printImage);
            this.setHyperlinkInfo(chunk, printImage);
            ColumnText colText = new ColumnText(this.pdfContentByte);
            int upperY = this.jasperPrint.getPageHeight() - printImage.getY() - topPadding - this.getOffsetY() - yoffset;
            int lowerX = printImage.getX() + leftPadding + this.getOffsetX() + xoffset;
            colText.setSimpleColumn(new Phrase(chunk), lowerX, (float)upperY - scaledHeight, (float)lowerX + scaledWidth, upperY, scaledHeight, 0);
            colText.go();
        }
        if (printImage.getTopBorder() == 0 && printImage.getLeftBorder() == 0 && printImage.getBottomBorder() == 0 && printImage.getRightBorder() == 0) {
            if (printImage.getPen() != 0) {
                this.exportBox(this.getBox(printImage), printImage);
            }
        } else {
            this.exportBox(printImage, printImage);
        }
    }

    private float getXAlignFactor(JRPrintImage printImage) {
        float xalignFactor = 0.0f;
        switch (printImage.getHorizontalAlignment()) {
            case 3: {
                xalignFactor = 1.0f;
                break;
            }
            case 2: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage printImage) {
        float yalignFactor = 0.0f;
        switch (printImage.getVerticalAlignment()) {
            case 3: {
                yalignFactor = 1.0f;
                break;
            }
            case 2: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected void setHyperlinkInfo(Chunk chunk, JRPrintHyperlink link) {
        switch (link.getHyperlinkType()) {
            case 2: {
                if (link.getHyperlinkReference() == null) break;
                chunk.setAnchor(link.getHyperlinkReference());
                break;
            }
            case 3: {
                if (link.getHyperlinkAnchor() == null) break;
                chunk.setLocalGoto(link.getHyperlinkAnchor());
                break;
            }
            case 4: {
                if (link.getHyperlinkPage() == null) break;
                chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString());
                break;
            }
            case 5: {
                if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkAnchor());
                break;
            }
            case 6: {
                if (link.getHyperlinkReference() == null || link.getHyperlinkPage() == null) break;
                chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkPage());
                break;
            }
            case 7: {
                String hyperlink;
                if (this.hyperlinkProducerFactory == null || (hyperlink = this.hyperlinkProducerFactory.produceHyperlink(link)) == null) break;
                chunk.setAnchor(hyperlink);
            }
        }
    }

    protected Phrase getPhrase(JRStyledText styledText, JRPrintText textElement) {
        Phrase phrase = new Phrase();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Chunk chunk = this.getChunk(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            this.setAnchor(chunk, textElement, textElement);
            this.setHyperlinkInfo(chunk, textElement);
            phrase.add(chunk);
            iterator.setIndex(runLimit);
        }
        return phrase;
    }

    protected Chunk getChunk(Map attributes, String text) {
        Object script;
        com.lowagie.text.Font font = this.getFont(attributes);
        Chunk chunk = new Chunk(text, font);
        Color backcolor = (Color)attributes.get(TextAttribute.BACKGROUND);
        if (backcolor != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setTextRise(font.leading(1.0f) / 2.0f);
            } else if (script != null && TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setTextRise(-font.leading(1.0f) / 2.0f);
            }
        }
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return chunk;
    }

    protected com.lowagie.text.Font getFont(Map attributes) {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Exception initialException = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        com.lowagie.text.Font font = null;
        PdfFont pdfFont = null;
        FontKey key = new FontKey(jrFont.getFontName(), jrFont.isBold(), jrFont.isItalic());
        pdfFont = this.fontMap != null && this.fontMap.containsKey(key) ? (PdfFont)this.fontMap.get(key) : new PdfFont(jrFont.getPdfFontName(), jrFont.getPdfEncoding(), jrFont.isPdfEmbedded());
        try {
            font = FontFactory.getFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), jrFont.getFontSize(), (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0), forecolor);
            if (font.getBaseFont() == null && font.family() == -1) {
                font = null;
            }
        }
        catch (Exception e2) {
            initialException = e2;
        }
        if (font == null) {
            byte[] bytes = null;
            try {
                bytes = JRLoader.loadBytesFromLocation(pdfFont.getPdfFontName(), this.classLoader, this.urlHandlerFactory);
            }
            catch (JRException e3) {
                throw new JRRuntimeException("Could not load the following font : \npdfFontName   : " + pdfFont.getPdfFontName() + "\npdfEncoding   : " + pdfFont.getPdfEncoding() + "\nisPdfEmbedded : " + pdfFont.isPdfEmbedded(), initialException);
            }
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont(pdfFont.getPdfFontName(), pdfFont.getPdfEncoding(), pdfFont.isPdfEmbedded(), true, bytes, null);
            }
            catch (DocumentException e4) {
                throw new JRRuntimeException(e4);
            }
            catch (IOException e5) {
                throw new JRRuntimeException(e5);
            }
            font = new com.lowagie.text.Font(baseFont, (float)jrFont.getFontSize(), (pdfFont.isPdfSimulatedBold() ? 1 : 0) | (pdfFont.isPdfSimulatedItalic() ? 2 : 0) | (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0), forecolor);
        }
        return font;
    }

    protected void exportText(JRPrintText text) throws DocumentException {
        JRStyledText styledText = this.getStyledText(text, false);
        if (styledText == null) {
            return;
        }
        int textLength = styledText.length();
        int x = text.getX() + this.getOffsetX();
        int y = text.getY() + this.getOffsetY();
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = text.getTopPadding();
        int leftPadding = text.getLeftPadding();
        int bottomPadding = text.getBottomPadding();
        int rightPadding = text.getRightPadding();
        int xFillCorrection = 0;
        int yFillCorrection = 0;
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + this.getOffsetY() + text.getHeight();
                xFillCorrection = 1;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + this.getOffsetX() + text.getWidth();
                yFillCorrection = -1;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
            case 3: {
                x = text.getX() + this.getOffsetX() + text.getWidth();
                y = text.getY() + this.getOffsetY() + text.getHeight();
                int tmpPadding = topPadding;
                topPadding = bottomPadding;
                bottomPadding = tmpPadding;
                tmpPadding = leftPadding;
                leftPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = Math.PI;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, x, this.jasperPrint.getPageHeight() - y);
        this.pdfContentByte.transform(atrans);
        if (text.getMode() == 1) {
            Color backcolor = text.getBackcolor();
            this.pdfContentByte.setRGBColorStroke(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.setLineWidth(1.0f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle(x + xFillCorrection, this.jasperPrint.getPageHeight() - y + yFillCorrection, width - 1, -height + 1);
            this.pdfContentByte.fillStroke();
        }
        if (textLength > 0) {
            int horizontalAlignment = 0;
            switch (text.getHorizontalAlignment()) {
                case 1: {
                    if (text.getRunDirection() == 0) {
                        horizontalAlignment = 0;
                        break;
                    }
                    horizontalAlignment = 2;
                    break;
                }
                case 2: {
                    horizontalAlignment = 1;
                    break;
                }
                case 3: {
                    if (text.getRunDirection() == 0) {
                        horizontalAlignment = 2;
                        break;
                    }
                    horizontalAlignment = 0;
                    break;
                }
                case 4: {
                    horizontalAlignment = 3;
                    break;
                }
                default: {
                    horizontalAlignment = 0;
                }
            }
            float verticalOffset = 0.0f;
            switch (text.getVerticalAlignment()) {
                case 1: {
                    verticalOffset = 0.0f;
                    break;
                }
                case 2: {
                    verticalOffset = ((float)(height - topPadding - bottomPadding) - text.getTextHeight()) / 2.0f;
                    break;
                }
                case 3: {
                    verticalOffset = (float)(height - topPadding - bottomPadding) - text.getTextHeight();
                    break;
                }
                default: {
                    verticalOffset = 0.0f;
                }
            }
            ColumnText colText = new ColumnText(this.pdfContentByte);
            colText.setSimpleColumn(this.getPhrase(styledText, text), x + leftPadding, (float)(this.jasperPrint.getPageHeight() - y - topPadding) - verticalOffset - text.getLeadingOffset(), x + width - rightPadding, this.jasperPrint.getPageHeight() - y - height + bottomPadding, 0.0f, horizontalAlignment);
            colText.setLeading(0.0f, text.getLineSpacingFactor());
            colText.setRunDirection(text.getRunDirection() == 0 ? 2 : 3);
            colText.go();
        }
        atrans = new AffineTransform();
        atrans.rotate(-angle, x, this.jasperPrint.getPageHeight() - y);
        this.pdfContentByte.transform(atrans);
        this.exportBox(text, text);
    }

    protected void exportBox(JRBox box, JRPrintElement element) {
        Color color;
        float borderCorrection;
        if (box.getTopBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getTopBorder());
            color = box.getTopBorderColor() == null ? element.getForecolor() : box.getTopBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + borderCorrection);
            this.pdfContentByte.stroke();
        }
        if (box.getLeftBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getLeftBorder());
            color = box.getLeftBorderColor() == null ? element.getForecolor() : box.getLeftBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.stroke();
        }
        if (box.getBottomBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getBottomBorder());
            color = box.getBottomBorderColor() == null ? element.getForecolor() : box.getBottomBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX()) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.stroke();
        }
        if (box.getRightBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getRightBorder());
            color = box.getRightBorderColor() == null ? element.getForecolor() : box.getRightBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.getOffsetX() + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY()) + borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.getOffsetX() + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.getOffsetY() - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.stroke();
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    private static float prepareBorder(PdfContentByte pdfContentByte, byte border) {
        float borderCorrection = 0.0f;
        switch (border) {
            case 4: {
                borderCorrection = 0.0f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                borderCorrection = 0.5f;
                pdfContentByte.setLineWidth(4.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                borderCorrection = 0.5f;
                pdfContentByte.setLineWidth(2.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                pdfContentByte.setLineWidth(0.5f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            default: {
                borderCorrection = 0.0f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(0.0f);
            }
        }
        return borderCorrection;
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            List fontDirs;
            List fontFiles = JRProperties.getProperties("net.sf.jasperreports.export.pdf.font.");
            if (!fontFiles.isEmpty()) {
                Iterator i2 = fontFiles.iterator();
                while (i2.hasNext()) {
                    JRProperties.PropertySuffix font = (JRProperties.PropertySuffix)i2.next();
                    String file = font.getValue();
                    if (file.toLowerCase().endsWith(".ttc")) {
                        FontFactory.register(file);
                        continue;
                    }
                    String alias = font.getSuffix();
                    FontFactory.register(file, alias);
                }
            }
            if (!(fontDirs = JRProperties.getProperties("net.sf.jasperreports.export.pdf.fontdir.")).isEmpty()) {
                Iterator i3 = fontDirs.iterator();
                while (i3.hasNext()) {
                    JRProperties.PropertySuffix dir = (JRProperties.PropertySuffix)i3.next();
                    FontFactory.registerDirectory(dir.getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks() {
        this.bookmarkStack = new BookmarkStack();
        int rootLevel = this.isModeBatch && this.isCreatingBatchModeBookmarks ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfContentByte.getRootOutline(), rootLevel);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int level, String title, int x, int y) {
        Bookmark parent = this.bookmarkStack.peek();
        while (parent.level > level - 1) {
            this.bookmarkStack.pop();
            parent = this.bookmarkStack.peek();
        }
        for (int i2 = parent.level + 1; i2 < level; ++i2) {
            Bookmark emptyBookmark = new Bookmark(parent, parent.pdfOutline.getPdfDestination(), EMPTY_BOOKMARK_TITLE);
            this.bookmarkStack.push(emptyBookmark);
            parent = emptyBookmark;
        }
        Bookmark bookmark = new Bookmark(parent, x, this.jasperPrint.getPageHeight() - y, title);
        this.bookmarkStack.push(bookmark);
    }

    protected void setAnchor(Chunk chunk, JRPrintAnchor anchor, JRPrintElement element) {
        String anchorName = anchor.getAnchorName();
        if (anchorName != null) {
            chunk.setLocalDestination(anchorName);
            if (anchor.getBookmarkLevel() != 0) {
                this.addBookmark(anchor.getBookmarkLevel(), anchor.getAnchorName(), element.getX(), element.getY());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(JRPrintFrame frame) throws DocumentException, IOException, JRException {
        if (frame.getMode() == 1) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            Color backcolor = frame.getBackcolor();
            this.pdfContentByte.setRGBColorStroke(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.setLineWidth(1.0f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle(x, this.jasperPrint.getPageHeight() - y, frame.getWidth() - 1, -frame.getHeight() + 1);
            this.pdfContentByte.fillStroke();
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(frame, frame);
    }

    class LocalFontMapper
    implements FontMapper {
        public BaseFont awtToPdf(Font font) {
            return JRPdfExporter.this.getFont(font.getAttributes()).getBaseFont();
        }

        public Font pdfToAwt(BaseFont font, int size) {
            return null;
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        public void write(int b2) {
        }

        public void write(byte[] b2, int off, int len) {
        }

        public void write(byte[] b2) {
        }
    }

    protected static class BookmarkStack {
        LinkedList stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return (Bookmark)this.stack.removeLast();
        }

        Bookmark peek() {
            return (Bookmark)this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutline pdfOutline;
        final int level;

        Bookmark(Bookmark parent, int x, int top, String title) {
            this(parent, new PdfDestination(0, x, top, 0.0f), title);
        }

        Bookmark(Bookmark parent, PdfDestination destination, String title) {
            this.pdfOutline = new PdfOutline(parent.pdfOutline, destination, title, false);
            this.level = parent.level + 1;
        }

        Bookmark(PdfOutline pdfOutline, int level) {
            this.pdfOutline = pdfOutline;
            this.level = level;
        }
    }
}

