/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.oasis.Style;

public class ParagraphStyle
extends Style {
    protected static final String HORIZONTAL_ALIGN_LEFT = "start";
    protected static final String HORIZONTAL_ALIGN_RIGHT = "end";
    protected static final String HORIZONTAL_ALIGN_CENTER = "center";
    protected static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private String verticalAlignment = "top";
    private String horizontalAlignment = null;
    private String runDirection = null;

    public ParagraphStyle(Writer styleWriter, JRPrintText text) {
        super(styleWriter);
        switch (text.getVerticalAlignment()) {
            case 3: {
                this.verticalAlignment = VERTICAL_ALIGN_BOTTOM;
                break;
            }
            case 2: {
                this.verticalAlignment = VERTICAL_ALIGN_MIDDLE;
                break;
            }
            default: {
                this.verticalAlignment = VERTICAL_ALIGN_TOP;
            }
        }
        this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
        switch (text.getHorizontalAlignment()) {
            case 3: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_RIGHT;
                break;
            }
            case 2: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_CENTER;
                break;
            }
            case 4: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_JUSTIFY;
                break;
            }
            default: {
                this.horizontalAlignment = HORIZONTAL_ALIGN_LEFT;
            }
        }
        this.runDirection = null;
        if (text.getRunDirection() == 1) {
            this.runDirection = "rl";
        }
    }

    public String getId() {
        return this.verticalAlignment + "|" + this.horizontalAlignment + "|" + this.runDirection;
    }

    public void write(String paragraphStyleName) throws IOException {
        this.styleWriter.write("<style:style style:name=\"" + paragraphStyleName + "\"");
        this.styleWriter.write(" style:family=\"paragraph\">\n");
        this.styleWriter.write("<style:paragraph-properties");
        this.styleWriter.write(" fo:text-align=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" style:vertical-align=\"" + this.verticalAlignment + "\"");
        if (this.runDirection != null) {
            this.styleWriter.write(" style:writing-mode=\"" + this.runDirection + "\"");
        }
        this.styleWriter.write("> \r\n");
        this.styleWriter.write("</style:paragraph-properties>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

