/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis.zip;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.oasis.zip.OasisZipEntry;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;

public class FileBufferedOasisZipEntry
implements OasisZipEntry {
    private String name = null;
    private FileBufferedOutputStream fbos = null;
    private Writer writer = null;

    public FileBufferedOasisZipEntry(String name) {
        this(name, null);
    }

    public FileBufferedOasisZipEntry(String name, byte[] bytes) {
        this.name = name;
        if (bytes == null) {
            this.fbos = new FileBufferedOutputStream();
        } else {
            this.fbos = new FileBufferedOutputStream(bytes.length);
            try {
                this.fbos.write(bytes);
            }
            catch (IOException e2) {
                throw new JRRuntimeException(e2);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Writer getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fbos, "UTF-8"));
        }
        return this.writer;
    }

    public OutputStream getOutputStream() {
        return this.fbos;
    }

    public void writeData(OutputStream os) throws IOException {
        this.fbos.writeData(os);
    }

    public void dispose() {
        this.fbos.dispose();
    }
}

