/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog(class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer == null ? (class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer = JRAbstractLRUVirtualizer.class$("net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer")) : class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer);
    private final Cache pagedIn;
    private final ReferenceMap pagedOut;
    protected JRVirtualizable lastObject;
    protected ReferenceMap lastObjectMap;
    protected ReferenceMap lastObjectSet;
    private boolean readOnly;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRAbstractLRUVirtualizer;

    protected JRAbstractLRUVirtualizer(int maxSize) {
        this.pagedIn = new Cache(maxSize);
        this.pagedOut = new ReferenceMap(0, 2);
        this.lastObject = null;
        this.lastObjectMap = new ReferenceMap(2, 2);
        this.lastObjectSet = new ReferenceMap(2, 0);
    }

    protected final synchronized boolean isPagedOut(String id) {
        return this.pagedOut.containsKey(id);
    }

    protected synchronized boolean isPagedOutAndTouch(JRVirtualizable o2, String uid) {
        boolean virtualized = this.isPagedOut(uid);
        if (!virtualized) {
            this.touch(o2);
        }
        return virtualized;
    }

    protected final void setLastObject(JRVirtualizable o2) {
        if (this.lastObject != o2) {
            JRVirtualizationContext context;
            Object ownerLast;
            if (o2 != null && (ownerLast = this.lastObjectMap.get(context = o2.getContext())) != o2) {
                if (ownerLast != null) {
                    this.lastObjectSet.remove(ownerLast);
                }
                this.lastObjectMap.put(context, o2);
                this.lastObjectSet.put(o2, Boolean.TRUE);
            }
            this.lastObject = o2;
        }
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected final boolean isReadOnly(JRVirtualizable o2) {
        return this.readOnly || o2.getContext().isReadOnly();
    }

    public synchronized void registerObject(JRVirtualizable o2) {
        this.setLastObject(o2);
        JRVirtualizable old = this.pagedIn.put(o2.getUID(), o2);
        if (old != null) {
            this.pagedIn.put(o2.getUID(), old);
            throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterObject(JRVirtualizable o2) {
        String uid = o2.getUID();
        try {
            this.dispose(o2.getUID());
        }
        catch (Exception e2) {
            log.error("Error removing virtual data", e2);
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            JRVirtualizable oldIn = this.pagedIn.remove(uid);
            if (oldIn != null) {
                if (oldIn != o2) {
                    this.pagedIn.put(uid, oldIn);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
                }
            } else {
                Object oldOut = this.pagedOut.remove(uid);
                if (oldOut != null && oldOut != o2) {
                    this.pagedOut.put(uid, oldOut);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o2.getUID() + "\"");
                }
            }
        }
    }

    public synchronized void touch(JRVirtualizable o2) {
        if (this.lastObject != o2) {
            this.setLastObject(this.pagedIn.get(o2.getUID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (this.isPagedOutAndTouch(o2, uid)) {
            try {
                this.pageIn(o2);
            }
            catch (IOException e2) {
                log.error("Error devirtualizing object", e2);
                throw new JRRuntimeException(e2);
            }
            o2.afterInternalization();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.setLastObject(o2);
                this.pagedOut.remove(uid);
                this.pagedIn.put(uid, o2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (this.isPagedOutAndTouch(o2, uid)) {
            this.dispose(uid);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.remove(uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void virtualizeData(JRVirtualizable o2) {
        String uid = o2.getUID();
        if (!this.isPagedOut(uid)) {
            o2.beforeExternalization();
            try {
                this.pageOut(o2);
            }
            catch (IOException e2) {
                log.error("Error virtualizing object", e2);
                throw new JRRuntimeException(e2);
            }
            o2.afterExternalization();
            o2.removeVirtualData();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.put(uid, o2);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected final void writeData(JRVirtualizable o2, OutputStream out) throws JRRuntimeException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(o2.getIdentityData());
            oos.writeObject(o2.getVirtualData());
            oos.flush();
        }
        catch (IOException e2) {
            log.error("Error virtualizing object", e2);
            throw new JRRuntimeException(e2);
        }
    }

    protected final void readData(JRVirtualizable o2, InputStream in) throws JRRuntimeException {
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            o2.setIdentityData(ois.readObject());
            o2.setVirtualData(ois.readObject());
        }
        catch (IOException e2) {
            log.error("Error devirtualizing object", e2);
            throw new JRRuntimeException(e2);
        }
        catch (ClassNotFoundException e3) {
            log.error("Error devirtualizing object", e3);
            throw new JRRuntimeException(e3);
        }
    }

    protected synchronized void reset() {
        this.readOnly = false;
    }

    protected final void disposeAll() {
        String id;
        Iterator it = this.pagedOut.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e2) {
                log.error("Error cleaning up virtualizer.", e2);
            }
        }
        it = this.pagedIn.idIterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e3) {
                log.error("Error cleaning up virtualizer.", e3);
            }
        }
    }

    protected abstract void pageOut(JRVirtualizable var1) throws IOException;

    protected abstract void pageIn(JRVirtualizable var1) throws IOException;

    protected abstract void dispose(String var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class Cache {
        private final ReferenceQueue refQueue;
        private final LRUScanMap map;

        Cache(int maxSize) {
            this.map = new LRUScanMap(maxSize);
            this.refQueue = new ReferenceQueue();
        }

        protected JRVirtualizable getMapValue(Object val) {
            Reference ref;
            JRVirtualizable o2 = val == null ? null : ((ref = (Reference)val).isEnqueued() ? null : (JRVirtualizable)ref.get());
            return o2;
        }

        protected Object toMapValue(JRVirtualizable val) {
            return val == null ? null : new CacheReference(val, this.refQueue);
        }

        protected void purge() {
            CacheReference ref;
            while ((ref = (CacheReference)this.refQueue.poll()) != null) {
                this.map.remove(ref.getId());
            }
        }

        public JRVirtualizable get(String id) {
            this.purge();
            return this.getMapValue(this.map.get(id));
        }

        public JRVirtualizable put(String id, JRVirtualizable o2) {
            this.purge();
            return this.getMapValue(this.map.put(id, this.toMapValue(o2)));
        }

        public JRVirtualizable remove(String id) {
            this.purge();
            return this.getMapValue(this.map.remove(id));
        }

        public Iterator idIterator() {
            this.purge();
            final Iterator valsIt = this.map.values().iterator();
            return new Iterator(){

                public boolean hasNext() {
                    return valsIt.hasNext();
                }

                public Object next() {
                    CacheReference ref = (CacheReference)valsIt.next();
                    return ref.getId();
                }

                public void remove() {
                    valsIt.remove();
                }
            };
        }

        protected class LRUScanMap
        extends LRUMap {
            private static final long serialVersionUID = 10200L;

            public LRUScanMap(int maxSize) {
                super(maxSize);
            }

            protected void removeLRU() {
                Map.Entry entry = this.getFirst();
                boolean found = this.isRemovable(entry);
                if (!found) {
                    Iterator entriesIt = this.entrySet().iterator();
                    entriesIt.next();
                    while (!found && entriesIt.hasNext()) {
                        entry = (Map.Entry)entriesIt.next();
                        found = this.isRemovable(entry);
                    }
                }
                if (!found) {
                    throw new JRRuntimeException("The virtualizer is used by more contexts than its in-memory cache size " + this.getMaximumSize());
                }
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.remove(key);
                this.processRemovedLRU(key, value);
            }

            protected boolean isRemovable(Map.Entry entry) {
                JRVirtualizable value = Cache.this.getMapValue(entry.getValue());
                return value == null || !((Cache)Cache.this).JRAbstractLRUVirtualizer.this.lastObjectSet.containsKey(value);
            }

            protected void processRemovedLRU(Object key, Object value) {
                JRVirtualizable o2 = Cache.this.getMapValue(value);
                if (o2 != null) {
                    JRAbstractLRUVirtualizer.this.virtualizeData(o2);
                }
            }
        }
    }

    protected static class CacheReference
    extends WeakReference {
        private final String id;

        public CacheReference(JRVirtualizable o2, ReferenceQueue queue) {
            super(o2, queue);
            this.id = o2.getUID();
        }

        public String getId() {
            return this.id;
        }
    }
}

