/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRPrintBand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRHorizontalFiller
extends JRBaseFiller {
    private static final Log log = LogFactory.getLog(class$net$sf$jasperreports$engine$fill$JRHorizontalFiller == null ? (class$net$sf$jasperreports$engine$fill$JRHorizontalFiller = JRHorizontalFiller.class$("net.sf.jasperreports.engine.fill.JRHorizontalFiller")) : class$net$sf$jasperreports$engine$fill$JRHorizontalFiller);
    private int lastDetailOffsetX = -1;
    private int lastDetailOffsetY = -1;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRHorizontalFiller;

    protected JRHorizontalFiller(JasperReport jasperReport) throws JRException {
        this(jasperReport, null, null);
    }

    protected JRHorizontalFiller(JasperReport jasperReport, JRBaseFiller parentFiller) throws JRException {
        super(jasperReport, null, parentFiller);
        this.setPageHeight(this.pageHeight);
    }

    protected JRHorizontalFiller(JasperReport jasperReport, JREvaluator evaluator, JRBaseFiller parentFiller) throws JRException {
        super(jasperReport, evaluator, parentFiller);
        this.setPageHeight(this.pageHeight);
    }

    protected void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
        this.columnFooterOffsetY = pageHeight - this.bottomMargin;
        if (this.pageFooter != null) {
            this.columnFooterOffsetY -= this.pageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.columnFooterOffsetY -= this.columnFooter.getHeight();
        }
        this.lastPageColumnFooterOffsetY = pageHeight - this.bottomMargin;
        if (this.lastPageFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.lastPageFooter.getHeight();
        }
        if (this.columnFooter != null) {
            this.lastPageColumnFooterOffsetY -= this.columnFooter.getHeight();
        }
    }

    protected synchronized void fillReport() throws JRException {
        this.setLastPageFooter(false);
        if (this.next()) {
            this.fillReportStart();
            while (this.next()) {
                this.fillReportContent();
            }
            this.fillReportEnd();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Fill " + this.fillerId + ": no data");
            }
            switch (this.whenNoDataType) {
                case 3: {
                    if (log.isDebugEnabled()) {
                        log.debug("Fill " + this.fillerId + ": all sections");
                    }
                    this.scriptlet.callBeforeReportInit();
                    this.calculator.initializeVariables((byte)1);
                    this.scriptlet.callAfterReportInit();
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    this.setFirstColumn();
                    this.offsetY = this.topMargin;
                    this.fillBackground();
                    this.fillTitle();
                    this.fillPageHeader((byte)3);
                    this.fillColumnHeaders((byte)3);
                    this.fillGroupHeaders(true);
                    this.fillGroupFooters(true);
                    this.fillSummary();
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug("Fill " + this.fillerId + ": blank page");
                    }
                    this.printPage = this.newPage();
                    this.addPage(this.printPage);
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Fill " + this.fillerId + ": no pages");
                }
            }
        }
        if (this.isSubreport()) {
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
        }
        if (this.fillContext.isIgnorePagination()) {
            this.jasperPrint.setPageHeight(this.offsetY + this.bottomMargin);
        }
    }

    private void fillReportStart() throws JRException {
        this.scriptlet.callBeforeReportInit();
        this.calculator.initializeVariables((byte)1);
        this.scriptlet.callAfterReportInit();
        this.printPage = this.newPage();
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.fillBackground();
        this.fillTitle();
        this.fillPageHeader((byte)3);
        this.fillColumnHeaders((byte)3);
        this.fillGroupHeaders(true);
        this.fillDetail();
    }

    private void setFirstColumn() {
        this.columnIndex = 0;
        this.offsetX = this.leftMargin;
        this.setColumnNumberVariable();
    }

    private void fillReportContent() throws JRException {
        this.calculator.estimateGroupRuptures();
        this.fillGroupFooters(false);
        this.resolveGroupBoundElements((byte)1, false);
        this.scriptlet.callBeforeGroupInit();
        this.calculator.initializeVariables((byte)4);
        this.scriptlet.callAfterGroupInit();
        this.fillGroupHeaders(false);
        this.fillDetail();
    }

    private void fillReportEnd() throws JRException {
        this.fillGroupFooters(true);
        this.fillSummary();
    }

    private void fillTitle() throws JRException {
        if (log.isDebugEnabled() && !this.title.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": title");
        }
        this.title.evaluatePrintWhenExpression((byte)3);
        if (this.title.isToPrint()) {
            while (this.title.getHeight() > this.pageHeight - this.bottomMargin - this.offsetY) {
                this.addPage(false);
            }
            this.title.evaluate((byte)3);
            JRPrintBand printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            if (this.title.willOverflow() && !this.title.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            while (this.title.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.title.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.title.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.title, (byte)3);
            if (this.isTitleNewPage) {
                this.resolveGroupBoundElements((byte)3, false);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
            }
        }
    }

    private void fillPageHeader(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.pageHeader.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": page header");
        }
        this.setNewPageColumnInBands();
        this.pageHeader.evaluatePrintWhenExpression((byte)3);
        if (this.pageHeader.isToPrint()) {
            int reattempts = this.getMasterColumnCount();
            if (this.isCreatingNewPage) {
                --reattempts;
            }
            boolean filled = this.fillBandNoOverflow(this.pageHeader, evaluation);
            for (int i2 = 0; !filled && i2 < reattempts; ++i2) {
                this.resolveGroupBoundElements(evaluation, false);
                this.resolveColumnBoundElements(evaluation);
                this.resolvePageBoundElements(evaluation);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                filled = this.fillBandNoOverflow(this.pageHeader, evaluation);
            }
            if (!filled) {
                throw new JRRuntimeException("Infinite loop creating new page due to page header overflow.");
            }
        }
        this.columnHeaderOffsetY = this.offsetY;
        this.isNewPage = true;
    }

    private boolean fillBandNoOverflow(JRFillBand band, byte evaluation) throws JRException {
        boolean overflow;
        int availableStretch = this.columnFooterOffsetY - this.offsetY - band.getHeight();
        boolean bl = overflow = availableStretch < 0;
        if (!overflow) {
            band.evaluate(evaluation);
            JRPrintBand printBand = band.fill(availableStretch);
            overflow = band.willOverflow();
            if (overflow) {
                band.rewind();
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.resolveBandBoundElements(band, evaluation);
            }
        }
        return !overflow;
    }

    private void fillColumnHeaders(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.columnHeader.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": column headers");
        }
        this.setNewPageColumnInBands();
        this.columnIndex = 0;
        while (this.columnIndex < this.columnCount) {
            this.setColumnNumberVariable();
            this.columnHeader.evaluatePrintWhenExpression(evaluation);
            if (this.columnHeader.isToPrint()) {
                int reattempts = this.getMasterColumnCount();
                if (this.isCreatingNewPage) {
                    --reattempts;
                }
                boolean fits = this.columnHeader.getHeight() <= this.columnFooterOffsetY - this.offsetY;
                for (int i2 = 0; !fits && i2 < reattempts; ++i2) {
                    this.fillPageFooter(evaluation);
                    this.resolveGroupBoundElements(evaluation, false);
                    this.resolveColumnBoundElements(evaluation);
                    this.resolvePageBoundElements(evaluation);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    this.fillPageHeader(evaluation);
                    fits = this.columnHeader.getHeight() <= this.columnFooterOffsetY - this.offsetY;
                }
                if (!fits) {
                    throw new JRRuntimeException("Infinite loop creating new page due to column header size.");
                }
                this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
                this.offsetY = this.columnHeaderOffsetY;
                this.fillFixedBand(this.columnHeader, evaluation, false);
            }
            ++this.columnIndex;
        }
        this.setFirstColumn();
        this.isNewColumn = true;
    }

    private void fillGroupHeaders(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                if (isFillAll) {
                    this.fillGroupHeader(this.groups[i2]);
                    continue;
                }
                if (!this.groups[i2].hasChanged()) continue;
                this.fillGroupHeader(this.groups[i2]);
            }
        }
    }

    private void fillGroupHeader(JRFillGroup group) throws JRException {
        byte evalPrevPage;
        JRFillBand groupHeader = (JRFillBand)group.getGroupHeader();
        if (log.isDebugEnabled() && !groupHeader.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": " + group.getName() + " header");
        }
        byte by = evalPrevPage = group.isTopLevelChange() ? (byte)1 : 3;
        if ((group.isStartNewPage() || group.isResetPageNumber()) && !this.isNewPage || group.isStartNewColumn() && !this.isNewColumn) {
            this.fillPageBreak(group.isResetPageNumber(), evalPrevPage, (byte)3, true);
        }
        groupHeader.evaluatePrintWhenExpression((byte)3);
        if (groupHeader.isToPrint()) {
            while (groupHeader.getHeight() > this.columnFooterOffsetY - this.offsetY || group.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                this.fillPageBreak(false, evalPrevPage, (byte)3, true);
            }
        }
        this.setNewGroupInBands(group);
        group.setFooterPrinted(false);
        if (groupHeader.isToPrint()) {
            this.setFirstColumn();
            this.fillColumnBand(groupHeader, (byte)3);
        }
        group.setHeaderPrinted(true);
        this.isNewGroup = true;
    }

    private void fillGroupHeadersReprint(byte evaluation) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                this.fillGroupHeaderReprint(this.groups[i2], evaluation);
            }
        }
    }

    private void fillGroupHeaderReprint(JRFillGroup group, byte evaluation) throws JRException {
        if (group.isReprintHeaderOnEachPage() && (!group.hasChanged() || group.hasChanged() && group.isHeaderPrinted())) {
            JRFillBand groupHeader = (JRFillBand)group.getGroupHeader();
            groupHeader.evaluatePrintWhenExpression(evaluation);
            if (groupHeader.isToPrint()) {
                this.setFirstColumn();
                while (groupHeader.getHeight() > this.columnFooterOffsetY - this.offsetY || group.getMinHeightToStartNewPage() > this.columnFooterOffsetY - this.offsetY) {
                    this.fillPageBreak(false, evaluation, evaluation, true);
                }
                this.fillColumnBand(groupHeader, evaluation);
            }
        }
    }

    private void fillDetail() throws JRException {
        if (log.isDebugEnabled() && !this.detail.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": detail");
        }
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.calculator.estimateVariables();
            this.detail.evaluatePrintWhenExpression((byte)2);
        }
        if (this.detail.isToPrint()) {
            while ((this.columnIndex == this.columnCount - 1 || this.isNewGroup) && this.detail.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                byte evalPrevPage = this.isNewGroup ? (byte)3 : 1;
                this.fillPageBreak(false, evalPrevPage, (byte)3, true);
            }
        }
        this.scriptlet.callBeforeDetailEval();
        this.calculator.calculateVariables();
        this.scriptlet.callAfterDetailEval();
        if (!this.detail.isPrintWhenExpressionNull()) {
            this.detail.evaluatePrintWhenExpression((byte)3);
        }
        if (this.detail.isToPrint()) {
            if (this.offsetX == this.lastDetailOffsetX && this.offsetY == this.lastDetailOffsetY) {
                if (this.columnIndex == this.columnCount - 1) {
                    this.setFirstColumn();
                } else {
                    ++this.columnIndex;
                    this.offsetX += this.columnWidth + this.columnSpacing;
                    this.offsetY -= this.detail.getHeight();
                    this.setColumnNumberVariable();
                }
            }
            this.fillFixedBand(this.detail, (byte)3, false);
            this.lastDetailOffsetX = this.offsetX;
            this.lastDetailOffsetY = this.offsetY;
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        this.isNewGroup = false;
    }

    private void fillGroupFooters(boolean isFillAll) throws JRException {
        if (this.groups != null && this.groups.length > 0) {
            byte evaluation = isFillAll ? (byte)3 : 1;
            for (int i2 = this.groups.length - 1; i2 >= 0; --i2) {
                if (isFillAll) {
                    this.fillGroupFooter(this.groups[i2], evaluation);
                    continue;
                }
                if (!this.groups[i2].hasChanged()) continue;
                this.fillGroupFooter(this.groups[i2], evaluation);
            }
        }
    }

    private void fillGroupFooter(JRFillGroup group, byte evaluation) throws JRException {
        JRFillBand groupFooter = (JRFillBand)group.getGroupFooter();
        if (log.isDebugEnabled() && !groupFooter.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": " + group.getName() + " footer");
        }
        groupFooter.evaluatePrintWhenExpression(evaluation);
        if (groupFooter.isToPrint()) {
            this.setFirstColumn();
            if (groupFooter.getHeight() > this.columnFooterOffsetY - this.offsetY) {
                this.fillPageBreak(false, evaluation, evaluation, true);
            }
            this.fillColumnBand(groupFooter, evaluation);
        }
        this.isNewPage = false;
        this.isNewColumn = false;
        group.setHeaderPrinted(false);
        group.setFooterPrinted(true);
    }

    private void fillColumnFooters(byte evaluation) throws JRException {
        if (log.isDebugEnabled() && !this.columnFooter.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": column footers");
        }
        if (this.isSubreport()) {
            this.columnFooterOffsetY = this.offsetY;
        }
        int tmpColumnFooterOffsetY = this.columnFooterOffsetY;
        if (this.isFloatColumnFooter || this.fillContext.isIgnorePagination()) {
            tmpColumnFooterOffsetY = this.offsetY;
        }
        this.columnIndex = 0;
        while (this.columnIndex < this.columnCount) {
            this.setColumnNumberVariable();
            this.offsetX = this.leftMargin + this.columnIndex * (this.columnSpacing + this.columnWidth);
            this.offsetY = tmpColumnFooterOffsetY;
            this.columnFooter.evaluatePrintWhenExpression(evaluation);
            if (this.columnFooter.isToPrint()) {
                this.fillFixedBand(this.columnFooter, evaluation, false);
            }
            ++this.columnIndex;
        }
    }

    private void fillPageFooter(byte evaluation) throws JRException {
        JRFillBand crtPageFooter = this.getCurrentPageFooter();
        if (log.isDebugEnabled() && !crtPageFooter.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": " + (this.isLastPageFooter ? "last " : "") + "page footer");
        }
        this.offsetX = this.leftMargin;
        if (!this.isSubreport() && !this.fillContext.isIgnorePagination()) {
            this.offsetY = this.pageHeight - crtPageFooter.getHeight() - this.bottomMargin;
        }
        crtPageFooter.evaluatePrintWhenExpression(evaluation);
        if (crtPageFooter.isToPrint()) {
            this.fillFixedBand(crtPageFooter, evaluation);
        }
    }

    private void fillSummary() throws JRException {
        if (log.isDebugEnabled() && !this.summary.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": summary");
        }
        this.offsetX = this.leftMargin;
        if (this.lastPageFooter == this.missingFillBand) {
            if (!this.isSummaryNewPage && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
                this.fillSummarySamePage();
            } else {
                this.fillSummaryNewPage();
            }
        } else if (!this.isSummaryNewPage && this.summary.getHeight() <= this.lastPageColumnFooterOffsetY - this.offsetY) {
            this.setLastPageFooter(true);
            this.fillSummarySamePage();
        } else if (!this.isSummaryNewPage && this.summary.getHeight() <= this.columnFooterOffsetY - this.offsetY) {
            this.fillSummarySamePageMixedFooters();
        } else if (this.offsetY <= this.lastPageColumnFooterOffsetY) {
            this.setLastPageFooter(true);
            this.fillSummaryNewPage();
        } else {
            this.fillPageBreak(false, (byte)3, (byte)3, false);
            this.setLastPageFooter(true);
            if (this.isSummaryNewPage) {
                this.fillSummaryNewPage();
            } else {
                this.fillSummarySamePage();
            }
        }
        this.resolveGroupBoundElements((byte)3, true);
        this.resolveColumnBoundElements((byte)3);
        this.resolvePageBoundElements((byte)3);
        this.resolveReportBoundElements();
    }

    private void fillSummarySamePage() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            this.fillColumnFooters((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummarySamePageMixedFooters() throws JRException {
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.columnFooterOffsetY - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed()) {
                if (this.offsetY <= this.lastPageColumnFooterOffsetY) {
                    this.setLastPageFooter(true);
                    this.fillColumnFooters((byte)3);
                    this.fillPageFooter((byte)3);
                    this.resolveGroupBoundElements((byte)3, true);
                    this.resolveColumnBoundElements((byte)3);
                    this.resolvePageBoundElements((byte)3);
                    this.scriptlet.callBeforePageInit();
                    this.calculator.initializeVariables((byte)2);
                    this.scriptlet.callAfterPageInit();
                    this.addPage(false);
                    printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                } else {
                    this.fillPageBreak(false, (byte)3, (byte)3, false);
                    this.setLastPageFooter(true);
                    printBand = this.summary.refill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                    this.fillColumnFooters((byte)3);
                    this.fillPageFooter((byte)3);
                }
            } else {
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
                this.fillPageBreak(false, (byte)3, (byte)3, false);
                this.setLastPageFooter(true);
                if (this.summary.willOverflow()) {
                    printBand = this.summary.fill(this.lastPageColumnFooterOffsetY - this.offsetY - this.summary.getHeight());
                    this.fillBand(printBand);
                    this.offsetY += printBand.getHeight();
                }
                this.fillColumnFooters((byte)3);
                this.fillPageFooter((byte)3);
            }
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        } else {
            if (this.offsetY > this.lastPageColumnFooterOffsetY) {
                this.fillPageBreak(false, (byte)3, (byte)3, false);
            }
            this.setLastPageFooter(true);
            this.fillColumnFooters((byte)3);
            this.fillPageFooter((byte)3);
        }
    }

    private void fillSummaryNewPage() throws JRException {
        this.fillColumnFooters((byte)3);
        this.fillPageFooter((byte)3);
        this.summary.evaluatePrintWhenExpression((byte)3);
        if (this.summary != this.missingFillBand && this.summary.isToPrint()) {
            this.resolveGroupBoundElements((byte)3, true);
            this.resolveColumnBoundElements((byte)3);
            this.resolvePageBoundElements((byte)3);
            this.scriptlet.callBeforePageInit();
            this.calculator.initializeVariables((byte)2);
            this.scriptlet.callAfterPageInit();
            this.addPage(false);
            this.columnIndex = -1;
            this.summary.evaluate((byte)3);
            JRPrintBand printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            if (this.summary.willOverflow() && !this.summary.isSplitAllowed() && this.isSubreport()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.refill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
            }
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
            while (this.summary.willOverflow()) {
                this.resolveGroupBoundElements((byte)3, true);
                this.resolveColumnBoundElements((byte)3);
                this.resolvePageBoundElements((byte)3);
                this.scriptlet.callBeforePageInit();
                this.calculator.initializeVariables((byte)2);
                this.scriptlet.callAfterPageInit();
                this.addPage(false);
                printBand = this.summary.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.summary.getHeight());
                this.fillBand(printBand);
                this.offsetY += printBand.getHeight();
            }
            this.resolveBandBoundElements(this.summary, (byte)3);
        }
    }

    private void fillBackground() throws JRException {
        if (log.isDebugEnabled() && !this.background.isEmpty()) {
            log.debug("Fill " + this.fillerId + ": background");
        }
        if (this.background.getHeight() <= this.pageHeight - this.bottomMargin - this.offsetY) {
            this.background.evaluatePrintWhenExpression((byte)3);
            if (this.background.isToPrint()) {
                this.background.evaluate((byte)3);
                JRPrintBand printBand = this.background.fill(this.pageHeight - this.bottomMargin - this.offsetY - this.background.getHeight());
                this.fillBand(printBand);
            }
        }
    }

    private void addPage(boolean isResetPageNumber) throws JRException {
        if (this.isSubreport()) {
            if (!this.parentFiller.isBandOverFlowAllowed()) {
                throw new JRRuntimeException("Subreport overflowed on a band that does not support overflow.");
            }
            this.printPageStretchHeight = this.offsetY + this.bottomMargin;
            if (this.fillContext.isUsingVirtualizer()) {
                this.removePageIdentityDataProvider();
            }
            this.suspendSubreportRunner();
        }
        this.printPage = this.newPage();
        if (this.isSubreport() && this.fillContext.isUsingVirtualizer()) {
            this.addPageIdentityDataProvider();
        }
        if (isResetPageNumber) {
            this.calculator.getPageNumber().setValue(new Integer(1));
        } else {
            this.calculator.getPageNumber().setValue(new Integer(((Number)this.calculator.getPageNumber().getValue()).intValue() + 1));
        }
        this.calculator.getPageNumber().setOldValue(this.calculator.getPageNumber().getValue());
        this.addPage(this.printPage);
        this.setFirstColumn();
        this.offsetY = this.topMargin;
        this.lastDetailOffsetX = -1;
        this.lastDetailOffsetY = -1;
        this.fillBackground();
    }

    private void setColumnNumberVariable() {
        JRFillVariable columnNumberVar = this.calculator.getColumnNumber();
        columnNumberVar.setValue(new Integer(this.columnIndex + 1));
        columnNumberVar.setOldValue(columnNumberVar.getValue());
    }

    private void fillPageBreak(boolean isResetPageNumber, byte evalPrevPage, byte evalNextPage, boolean isReprintGroupHeaders) throws JRException {
        if (this.isCreatingNewPage) {
            throw new JRException("Infinite loop creating new page.");
        }
        this.isCreatingNewPage = true;
        this.fillColumnFooters(evalPrevPage);
        this.fillPageFooter(evalPrevPage);
        this.resolveGroupBoundElements(evalPrevPage, false);
        this.resolveColumnBoundElements(evalPrevPage);
        this.resolvePageBoundElements(evalPrevPage);
        this.scriptlet.callBeforePageInit();
        this.calculator.initializeVariables((byte)2);
        this.scriptlet.callAfterPageInit();
        this.addPage(isResetPageNumber);
        this.fillPageHeader(evalNextPage);
        this.fillColumnHeaders(evalNextPage);
        if (isReprintGroupHeaders) {
            this.fillGroupHeadersReprint(evalNextPage);
        }
        this.isCreatingNewPage = false;
    }

    protected void fillPageBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        if (band.willOverflow() && !band.isSplitAllowed()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.refill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        }
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        while (band.willOverflow()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
        }
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillColumnBand(JRFillBand band, byte evaluation) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        if (band.willOverflow() && !band.isSplitAllowed()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.refill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
        }
        this.fillBand(printBand);
        this.offsetY += printBand.getHeight();
        while (band.willOverflow()) {
            this.fillPageBreak(false, evaluation, evaluation, true);
            printBand = band.fill(this.columnFooterOffsetY - this.offsetY - band.getHeight());
            this.fillBand(printBand);
            this.offsetY += printBand.getHeight();
        }
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillFixedBand(JRFillBand band, byte evaluation) throws JRException {
        this.fillFixedBand(band, evaluation, true);
    }

    protected void fillFixedBand(JRFillBand band, byte evaluation, boolean allowShrinking) throws JRException {
        band.evaluate(evaluation);
        JRPrintBand printBand = band.fill();
        this.fillBand(printBand);
        this.offsetY += allowShrinking ? printBand.getHeight() : band.getHeight();
        this.resolveBandBoundElements(band, evaluation);
    }

    protected void fillBand(JRPrintBand band) {
        List elements = band.getElements();
        if (elements != null && elements.size() > 0) {
            JRPrintElement element = null;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                element.setX(element.getX() + this.offsetX);
                element.setY(element.getY() + this.offsetY);
                this.printPage.addElement(element);
            }
        }
    }

    private void setNewPageColumnInBands() {
        this.title.setNewPageColumn(true);
        this.pageHeader.setNewPageColumn(true);
        this.columnHeader.setNewPageColumn(true);
        this.detail.setNewPageColumn(true);
        this.columnFooter.setNewPageColumn(true);
        this.pageFooter.setNewPageColumn(true);
        this.lastPageFooter.setNewPageColumn(true);
        this.summary.setNewPageColumn(true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                ((JRFillBand)this.groups[i2].getGroupHeader()).setNewPageColumn(true);
                ((JRFillBand)this.groups[i2].getGroupFooter()).setNewPageColumn(true);
            }
        }
    }

    private void setNewGroupInBands(JRGroup group) {
        this.title.setNewGroup(group, true);
        this.pageHeader.setNewGroup(group, true);
        this.columnHeader.setNewGroup(group, true);
        this.detail.setNewGroup(group, true);
        this.columnFooter.setNewGroup(group, true);
        this.pageFooter.setNewGroup(group, true);
        this.lastPageFooter.setNewGroup(group, true);
        this.summary.setNewGroup(group, true);
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                ((JRFillBand)this.groups[i2].getGroupHeader()).setNewGroup(group, true);
                ((JRFillBand)this.groups[i2].getGroupFooter()).setNewGroup(group, true);
            }
        }
    }

    private JRFillBand getCurrentPageFooter() {
        return this.isLastPageFooter ? this.lastPageFooter : this.pageFooter;
    }

    private void setLastPageFooter(boolean isLastPageFooter) {
        this.isLastPageFooter = isLastPageFooter;
        if (isLastPageFooter) {
            this.columnFooterOffsetY = this.lastPageColumnFooterOffsetY;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

