/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;

public class JRSwapFileVirtualizer
extends JRAbstractLRUVirtualizer {
    private final JRSwapFile swap;
    private final boolean swapOwner;
    private final Map handles;

    public JRSwapFileVirtualizer(int maxSize, JRSwapFile swap) {
        this(maxSize, swap, true);
    }

    public JRSwapFileVirtualizer(int maxSize, JRSwapFile swap, boolean swapOwner) {
        super(maxSize);
        this.swap = swap;
        this.swapOwner = swapOwner;
        this.handles = Collections.synchronizedMap(new HashMap());
    }

    protected void pageOut(JRVirtualizable o2) throws IOException {
        if (!this.handles.containsKey(o2.getUID())) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(3000);
            this.writeData(o2, bout);
            byte[] data = bout.toByteArray();
            JRSwapFile.SwapHandle handle = this.swap.write(data);
            this.handles.put(o2.getUID(), handle);
        } else if (!this.isReadOnly(o2)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + o2.getUID() + "\" already exists.");
        }
    }

    protected void pageIn(JRVirtualizable o2) throws IOException {
        JRSwapFile.SwapHandle handle = (JRSwapFile.SwapHandle)this.handles.get(o2.getUID());
        byte[] data = this.swap.read(handle, !this.isReadOnly(o2));
        this.readData(o2, new ByteArrayInputStream(data));
        if (!this.isReadOnly(o2)) {
            this.handles.remove(o2.getUID());
        }
    }

    protected void dispose(String id) {
        JRSwapFile.SwapHandle handle = (JRSwapFile.SwapHandle)this.handles.remove(id);
        if (handle != null) {
            this.swap.free(handle);
        }
    }

    public void cleanup() {
        this.handles.clear();
        if (this.swapOwner) {
            this.swap.dispose();
        }
    }
}

