/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.ReferenceMap;

public class JRSingletonCache {
    private final ReferenceMap cache = new ReferenceMap();
    private final Class itf;

    public JRSingletonCache(Class itf) {
        this.itf = itf;
    }

    public synchronized Object getCachedInstance(String className) throws JRException {
        Object instance = this.cache.get(className);
        if (instance == null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(className);
                if (this.itf != null && !this.itf.isAssignableFrom(clazz)) {
                    throw new JRException("Class \"" + className + "\" should be compatible with \"" + this.itf.getName() + "\"");
                }
                instance = clazz.newInstance();
            }
            catch (ClassNotFoundException e2) {
                throw new JRException("Class " + className + " not found.", e2);
            }
            catch (InstantiationException e3) {
                throw new JRException("Error instantiating class " + className + ".", e3);
            }
            catch (IllegalAccessException e4) {
                throw new JRException("Error instantiating class " + className + ".", e4);
            }
            this.cache.put(className, instance);
        }
        return instance;
    }
}

