/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

public class JRStringUtil {
    public static String xmlEncode(String text) {
        int length = text.length();
        if (text != null && length > 0) {
            StringBuffer ret = new StringBuffer(length * 12 / 10);
            int last = 0;
            block7: for (int i2 = 0; i2 < length; ++i2) {
                char c2 = text.charAt(i2);
                switch (c2) {
                    case '&': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&amp;");
                        continue block7;
                    }
                    case '>': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&gt;");
                        continue block7;
                    }
                    case '<': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&lt;");
                        continue block7;
                    }
                    case '\"': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&quot;");
                        continue block7;
                    }
                    case '\'': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&apos;");
                        continue block7;
                    }
                }
            }
            if (last < length) {
                ret.append(text.substring(last));
            }
            return ret.toString();
        }
        return text;
    }

    public static String htmlEncode(String text) {
        int length = text.length();
        if (text != null && length > 0) {
            StringBuffer ret = new StringBuffer(length * 12 / 10);
            boolean isEncodeSpace = true;
            int last = 0;
            block8: for (int i2 = 0; i2 < length; ++i2) {
                char c2 = text.charAt(i2);
                switch (c2) {
                    case ' ': {
                        if (isEncodeSpace) {
                            if (last < i2) {
                                ret.append(text.substring(last, i2));
                            }
                            last = i2 + 1;
                            ret.append("&nbsp;");
                            isEncodeSpace = false;
                            continue block8;
                        }
                        isEncodeSpace = true;
                        continue block8;
                    }
                    case '&': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&amp;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '>': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&gt;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '<': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&lt;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '\"': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("&quot;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    case '\n': {
                        if (last < i2) {
                            ret.append(text.substring(last, i2));
                        }
                        last = i2 + 1;
                        ret.append("<br/>");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    default: {
                        isEncodeSpace = false;
                    }
                }
            }
            if (last < length) {
                ret.append(text.substring(last));
            }
            return ret.toString();
        }
        return text;
    }

    public static String getLiteral(String name) {
        if (JRStringUtil.isValidLiteral(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i2 = 0; i2 < literalChars.length; ++i2) {
            if (i2 == 0 && !Character.isJavaIdentifierStart(literalChars[i2])) {
                buffer.append((int)literalChars[i2]);
                continue;
            }
            if (i2 != 0 && !Character.isJavaIdentifierPart(literalChars[i2])) {
                buffer.append((int)literalChars[i2]);
                continue;
            }
            buffer.append(literalChars[i2]);
        }
        return buffer.toString();
    }

    private static boolean isValidLiteral(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i2 = 0; i2 < literalChars.length; ++i2) {
            if (i2 == 0 && !Character.isJavaIdentifierStart(literalChars[i2])) {
                result = false;
                break;
            }
            if (i2 == 0 || Character.isJavaIdentifierPart(literalChars[i2])) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String replaceDosEOL(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        int length = text.length();
        char[] chars = text.toCharArray();
        int r = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = chars[i2];
            if (ch != '\r' || i2 + 1 >= length || chars[i2 + 1] != '\n') {
                if (r <= 0) continue;
                chars[i2 - r] = ch;
                continue;
            }
            ++r;
        }
        return r > 0 ? new String(chars, 0, length - r) : text;
    }
}

