/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;

public abstract class AbstractXlsServlet
extends BaseHttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        Boolean isBuffered = Boolean.valueOf(request.getParameter("buffered"));
        if (isBuffered.booleanValue()) {
            JRXlsAbstractExporter exporter = this.getXlsExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, jasperPrintList);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, baos);
            exporter.setParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);
            exporter.setParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
            try {
                exporter.exportReport();
            }
            catch (JRException e2) {
                throw new ServletException((Throwable)e2);
            }
            byte[] bytes = baos.toByteArray();
            if (bytes != null && bytes.length > 0) {
                response.setContentType("application/xls");
                response.setHeader("Content-Disposition", "inline; filename=\"file.xls\"");
                response.setContentLength(bytes.length);
                ServletOutputStream ouputStream = response.getOutputStream();
                try {
                    ouputStream.write(bytes, 0, bytes.length);
                    ouputStream.flush();
                }
                finally {
                    if (ouputStream != null) {
                        try {
                            ouputStream.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        } else {
            response.setContentType("application/xls");
            response.setHeader("Content-Disposition", "inline; filename=\"file.xls\"");
            JRXlsAbstractExporter exporter = this.getXlsExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, jasperPrintList);
            ServletOutputStream ouputStream = response.getOutputStream();
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, ouputStream);
            exporter.setParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, Boolean.FALSE);
            exporter.setParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
            try {
                exporter.exportReport();
            }
            catch (JRException e3) {
                throw new ServletException((Throwable)e3);
            }
            finally {
                if (ouputStream != null) {
                    try {
                        ouputStream.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    protected abstract JRXlsAbstractExporter getXlsExporter();
}

