/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.Collection;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JRPreviewBuilder;
import net.sf.jasperreports.view.JRViewer;

public class JRDesignViewer
extends JRViewer {
    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        super(fileName, isXML);
        this.loadReport(fileName, isXML);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        super(is, isXML);
        this.loadReport(is, isXML);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(JRReport report) throws JRException {
        super(new JRPreviewBuilder(report).getJasperPrint());
        this.hideUnusedComponents();
    }

    private void hideUnusedComponents() {
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrevious.setVisible(false);
        this.btnNext.setVisible(false);
        this.txtGoTo.setVisible(false);
        this.pnlStatus.setVisible(false);
    }

    void btnReloadActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.forceRefresh();
            }
            catch (JRException e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection brokenRules = JasperCompileManager.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            throw new JRValidationException(brokenRules);
        }
    }

    protected void loadReport(String fileName, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(fileName));
        }
        this.type = 1;
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
    }

    protected void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(is));
        }
        this.type = 2;
        this.isXML = isXmlReport;
    }

    protected void loadReport(JRReport rep) throws JRException {
        this.setReport(rep);
        this.type = 3;
        this.isXML = false;
    }

    private void setReport(JRReport report) throws JRException {
        if (report instanceof JasperDesign) {
            this.verifyDesign((JasperDesign)report);
        }
        this.jasperPrint = new JRPreviewBuilder(report).getJasperPrint();
    }
}

