/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.javaflow.bytecode.transformation.asm.ContinuationMethodAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.DataflowInterpreter;
import org.objectweb.asm.tree.analysis.DataflowValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

public class ContinuationMethodAnalyzer
extends MethodNode
implements Opcodes {
    protected final String className;
    protected final ClassVisitor cv;
    protected final MethodVisitor mv;
    protected final List labels = new ArrayList();
    protected final List nodes = new ArrayList();
    protected final List methods = new ArrayList();
    protected Analyzer analyzer;
    public int stackRecorderVar;

    public ContinuationMethodAnalyzer(String className, ClassVisitor cv, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(access, name, desc, signature, exceptions);
        this.className = className;
        this.cv = cv;
        this.mv = mv;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        MethodInsnNode mnode = new MethodInsnNode(opcode, owner, name, desc);
        if (opcode == 183 || "<init>".equals(name)) {
            this.methods.add(mnode);
        }
        if (this.needsFrameGuard(opcode, owner, name, desc)) {
            Label label = new Label();
            super.visitLabel(label);
            this.labels.add(label);
            this.nodes.add(mnode);
        }
        this.instructions.add(mnode);
    }

    public void visitEnd() {
        if (this.instructions.size() == 0 || this.labels.size() == 0) {
            this.accept(this.mv);
            return;
        }
        this.stackRecorderVar = this.maxLocals;
        try {
            this.moveNew();
            this.analyzer = new Analyzer((Interpreter)new SimpleVerifier(){

                protected Class getClass(Type t) {
                    try {
                        if (t.getSort() == 9) {
                            return Class.forName(t.getDescriptor().replace('/', '.'), true, Thread.currentThread().getContextClassLoader());
                        }
                        return Class.forName(t.getClassName(), true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e2) {
                        throw new RuntimeException(e2.toString());
                    }
                }
            });
            this.analyzer.analyze(this.className, (MethodNode)this);
            this.accept((MethodVisitor)new ContinuationMethodAdapter(this));
        }
        catch (AnalyzerException ex) {
            ex.printStackTrace();
            this.accept(this.mv);
        }
    }

    void moveNew() throws AnalyzerException {
        DataflowInterpreter i2 = new DataflowInterpreter();
        Analyzer a2 = new Analyzer((Interpreter)i2);
        a2.analyze(this.className, (MethodNode)this);
        HashMap<AbstractInsnNode, MethodInsnNode> movable = new HashMap<AbstractInsnNode, MethodInsnNode>();
        Frame[] frames = a2.getFrames();
        for (int j2 = 0; j2 < this.methods.size(); ++j2) {
            MethodInsnNode mnode = (MethodInsnNode)this.methods.get(j2);
            int n2 = a2.getIndex((Object)mnode);
            Frame f2 = frames[n2];
            Type[] args = Type.getArgumentTypes(mnode.desc);
            DataflowValue v = (DataflowValue)f2.getStack(f2.getStackSize() - args.length - 1);
            Set insns = v.insns;
            Iterator it = insns.iterator();
            while (it.hasNext()) {
                AbstractInsnNode ins1;
                AbstractInsnNode ins = (AbstractInsnNode)it.next();
                if (ins.getOpcode() == 187) {
                    movable.put(ins, mnode);
                    continue;
                }
                int n1 = a2.getIndex((Object)ins);
                if (ins.getOpcode() == 89) {
                    ins1 = (AbstractInsnNode)this.instructions.get(n1 - 1);
                    if (ins1.getOpcode() != 187) continue;
                    movable.put(ins1, mnode);
                    continue;
                }
                if (ins.getOpcode() != 95) continue;
                ins1 = (AbstractInsnNode)this.instructions.get(n1 - 1);
                AbstractInsnNode ins2 = (AbstractInsnNode)this.instructions.get(n1 - 2);
                if (ins1.getOpcode() != 90 || ins2.getOpcode() != 187) continue;
                movable.put(ins2, mnode);
            }
        }
        int updateMaxStack = 0;
        Iterator it = movable.entrySet().iterator();
        while (it.hasNext()) {
            Type type;
            int j3;
            Map.Entry e2 = it.next();
            AbstractInsnNode node1 = (AbstractInsnNode)e2.getKey();
            int n1 = this.instructions.indexOf(node1);
            AbstractInsnNode node2 = (AbstractInsnNode)this.instructions.get(n1 + 1);
            AbstractInsnNode node3 = (AbstractInsnNode)this.instructions.get(n1 + 2);
            int producer = node2.getOpcode();
            this.instructions.remove(node1);
            boolean requireDup = false;
            if (producer == 89) {
                this.instructions.remove(node2);
                requireDup = true;
            } else if (producer == 90) {
                this.instructions.remove(node2);
                this.instructions.remove(node3);
                requireDup = true;
            }
            MethodInsnNode mnode = (MethodInsnNode)e2.getValue();
            int nm = this.instructions.indexOf(mnode);
            int varOffset = this.stackRecorderVar + 1;
            Type[] args = Type.getArgumentTypes(mnode.desc);
            if (args.length == 0) {
                this.instructions.add(nm++, node1);
                if (!requireDup) continue;
                this.instructions.add(nm++, new InsnNode(89));
                continue;
            }
            if (args.length == 1 && args[0].getSize() == 1) {
                this.instructions.add(nm++, node1);
                if (requireDup) {
                    this.instructions.add(nm++, new InsnNode(89));
                    this.instructions.add(nm++, new InsnNode(93));
                    this.instructions.add(nm++, new InsnNode(88));
                    updateMaxStack = updateMaxStack < 2 ? 2 : updateMaxStack;
                    continue;
                }
                this.instructions.add(nm++, new InsnNode(95));
                continue;
            }
            if (args.length == 1 && args[0].getSize() == 2 || args.length == 2 && args[0].getSize() == 1 && args[1].getSize() == 1) {
                this.instructions.add(nm++, node1);
                if (requireDup) {
                    this.instructions.add(nm++, new InsnNode(89));
                    this.instructions.add(nm++, new InsnNode(94));
                    this.instructions.add(nm++, new InsnNode(88));
                    updateMaxStack = updateMaxStack < 2 ? 2 : updateMaxStack;
                    continue;
                }
                this.instructions.add(nm++, new InsnNode(91));
                this.instructions.add(nm++, new InsnNode(87));
                updateMaxStack = updateMaxStack < 1 ? 1 : updateMaxStack;
                continue;
            }
            for (j3 = args.length - 1; j3 >= 0; --j3) {
                type = args[j3];
                this.instructions.add(nm++, new VarInsnNode(type.getOpcode(54), varOffset));
                varOffset += type.getSize();
            }
            if (varOffset > this.maxLocals) {
                this.maxLocals = varOffset;
            }
            this.instructions.add(nm++, node1);
            if (requireDup) {
                this.instructions.add(nm++, new InsnNode(89));
            }
            for (j3 = 0; j3 < args.length; ++j3) {
                type = args[j3];
                this.instructions.add(nm++, new VarInsnNode(type.getOpcode(21), varOffset -= type.getSize()));
                if (type.getSort() != 10 && type.getSort() != 9) continue;
                updateMaxStack = updateMaxStack < 1 ? 1 : updateMaxStack;
                this.instructions.add(nm++, new InsnNode(1));
                this.instructions.add(nm++, new VarInsnNode(type.getOpcode(54), varOffset));
            }
        }
        this.maxStack += updateMaxStack;
    }

    boolean needsFrameGuard(int opcode, String owner, String name, String desc) {
        return opcode == 185 || opcode == 183 && !"<init>".equals(name) || opcode == 184 || opcode == 182;
    }
}

