/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.bcel.analyser;

import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.RET;
import org.apache.commons.javaflow.bytecode.transformation.bcel.analyser.InstructionContext;

public final class ExecutionPath {
    public static final ExecutionPath EMPTY = new ExecutionPath(null, null);
    private final ExecutionPath prev;
    private final InstructionContext last;

    private ExecutionPath(ExecutionPath prev, InstructionContext last) {
        this.prev = prev;
        this.last = last;
    }

    public ExecutionPath append(InstructionContext ins) {
        return new ExecutionPath(this, ins);
    }

    public InstructionContext lastExecutionJSR() {
        int retcount = 0;
        ExecutionPath ptr = this;
        while (ptr != EMPTY) {
            Instruction i2 = ptr.last.getInstruction().getInstruction();
            if (i2 instanceof RET) {
                ++retcount;
            }
            if (i2 instanceof JsrInstruction && --retcount == -1) {
                return ptr.last;
            }
            ptr = ptr.prev;
        }
        return null;
    }

    public String toString() {
        if (this == EMPTY) {
            return "";
        }
        return this.prev.toString() + "\n" + this.last.toString();
    }
}

