/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hssf.model.AbstractShape;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;

public class PictureShape
extends AbstractShape {
    private EscherContainerRecord spContainer;
    private ObjRecord objRecord;

    PictureShape(HSSFSimpleShape hssfShape, int shapeId) {
        this.spContainer = this.createSpContainer(hssfShape, shapeId);
        this.objRecord = this.createObjRecord(hssfShape, shapeId);
    }

    private EscherContainerRecord createSpContainer(HSSFSimpleShape hssfShape, int shapeId) {
        HSSFPicture shape = (HSSFPicture)hssfShape;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        sp.setRecordId((short)-4086);
        sp.setOptions((short)1202);
        sp.setShapeId(shapeId);
        sp.setFlags(2560);
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherSimpleProperty(260, false, true, shape.getPictureIndex()));
        this.addStandardOptions(shape, opt);
        HSSFAnchor userAnchor = shape.getAnchor();
        if (userAnchor.isHorizontallyFlipped()) {
            sp.setFlags(sp.getFlags() | 0x40);
        }
        if (userAnchor.isVerticallyFlipped()) {
            sp.setFlags(sp.getFlags() | 0x80);
        }
        EscherRecord anchor = this.createAnchor(userAnchor);
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        return spContainer;
    }

    private ObjRecord createObjRecord(HSSFShape hssfShape, int shapeId) {
        HSSFShape shape = hssfShape;
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord c2 = new CommonObjectDataSubRecord();
        c2.setObjectType((short)((HSSFSimpleShape)shape).getShapeType());
        c2.setObjectId(this.getCmoObjectId(shapeId));
        c2.setLocked(true);
        c2.setPrintable(true);
        c2.setAutofill(true);
        c2.setAutoline(true);
        c2.setReserved2(0);
        EndSubRecord e2 = new EndSubRecord();
        obj.addSubRecord(c2);
        obj.addSubRecord(e2);
        return obj;
    }

    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    public ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

