/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class POIFSDump {
    public static void main(String[] args) throws Exception {
        for (int i2 = 0; i2 < args.length; ++i2) {
            System.out.println("Dumping " + args[i2]);
            FileInputStream is = new FileInputStream(args[i2]);
            POIFSFileSystem fs = new POIFSFileSystem(is);
            is.close();
            DirectoryNode root = fs.getRoot();
            File file = new File(root.getName());
            file.mkdir();
            POIFSDump.dump(root, file);
        }
    }

    public static void dump(DirectoryEntry root, File parent) throws IOException {
        Iterator<Entry> it = root.getEntries();
        while (it.hasNext()) {
            Entry entry = it.next();
            if (entry instanceof DocumentNode) {
                DocumentNode node = (DocumentNode)entry;
                DocumentInputStream is = new DocumentInputStream(node);
                byte[] bytes = new byte[node.getSize()];
                is.read(bytes);
                is.close();
                FileOutputStream out = new FileOutputStream(new File(parent, node.getName().trim()));
                out.write(bytes);
                out.close();
                continue;
            }
            if (entry instanceof DirectoryEntry) {
                DirectoryEntry dir = (DirectoryEntry)entry;
                File file = new File(parent, entry.getName());
                file.mkdir();
                POIFSDump.dump(dir, file);
                continue;
            }
            System.err.println("Skipping unsupported POIFS entry: " + entry);
        }
    }
}

