/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.atp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.atp.MRound;
import org.apache.poi.ss.formula.atp.NetworkdaysFunction;
import org.apache.poi.ss.formula.atp.ParityFunction;
import org.apache.poi.ss.formula.atp.RandBetween;
import org.apache.poi.ss.formula.atp.WorkdayFunction;
import org.apache.poi.ss.formula.atp.YearFrac;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.function.FunctionMetadata;
import org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.functions.Sumifs;
import org.apache.poi.ss.formula.udf.UDFFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnalysisToolPak
implements UDFFinder {
    public static final UDFFinder instance = new AnalysisToolPak();
    private final Map<String, FreeRefFunction> _functionsByName = this.createFunctionsMap();

    private AnalysisToolPak() {
    }

    @Override
    public FreeRefFunction findFunction(String name) {
        if (name.startsWith("_xlfn.")) {
            name = name.substring(6);
        }
        return this._functionsByName.get(name.toUpperCase());
    }

    private Map<String, FreeRefFunction> createFunctionsMap() {
        HashMap<String, FreeRefFunction> m2 = new HashMap<String, FreeRefFunction>(108);
        AnalysisToolPak.r(m2, "ACCRINT", null);
        AnalysisToolPak.r(m2, "ACCRINTM", null);
        AnalysisToolPak.r(m2, "AMORDEGRC", null);
        AnalysisToolPak.r(m2, "AMORLINC", null);
        AnalysisToolPak.r(m2, "AVERAGEIF", null);
        AnalysisToolPak.r(m2, "AVERAGEIFS", null);
        AnalysisToolPak.r(m2, "BAHTTEXT", null);
        AnalysisToolPak.r(m2, "BESSELI", null);
        AnalysisToolPak.r(m2, "BESSELJ", null);
        AnalysisToolPak.r(m2, "BESSELK", null);
        AnalysisToolPak.r(m2, "BESSELY", null);
        AnalysisToolPak.r(m2, "BIN2DEC", null);
        AnalysisToolPak.r(m2, "BIN2HEX", null);
        AnalysisToolPak.r(m2, "BIN2OCT", null);
        AnalysisToolPak.r(m2, "COMPLEX", null);
        AnalysisToolPak.r(m2, "CONVERT", null);
        AnalysisToolPak.r(m2, "COUNTIFS", null);
        AnalysisToolPak.r(m2, "COUPDAYBS", null);
        AnalysisToolPak.r(m2, "COUPDAYS", null);
        AnalysisToolPak.r(m2, "COUPDAYSNC", null);
        AnalysisToolPak.r(m2, "COUPNCD", null);
        AnalysisToolPak.r(m2, "COUPNUM", null);
        AnalysisToolPak.r(m2, "COUPPCD", null);
        AnalysisToolPak.r(m2, "CUBEKPIMEMBER", null);
        AnalysisToolPak.r(m2, "CUBEMEMBER", null);
        AnalysisToolPak.r(m2, "CUBEMEMBERPROPERTY", null);
        AnalysisToolPak.r(m2, "CUBERANKEDMEMBER", null);
        AnalysisToolPak.r(m2, "CUBESET", null);
        AnalysisToolPak.r(m2, "CUBESETCOUNT", null);
        AnalysisToolPak.r(m2, "CUBEVALUE", null);
        AnalysisToolPak.r(m2, "CUMIPMT", null);
        AnalysisToolPak.r(m2, "CUMPRINC", null);
        AnalysisToolPak.r(m2, "DEC2BIN", null);
        AnalysisToolPak.r(m2, "DEC2HEX", null);
        AnalysisToolPak.r(m2, "DEC2OCT", null);
        AnalysisToolPak.r(m2, "DELTA", null);
        AnalysisToolPak.r(m2, "DISC", null);
        AnalysisToolPak.r(m2, "DOLLARDE", null);
        AnalysisToolPak.r(m2, "DOLLARFR", null);
        AnalysisToolPak.r(m2, "DURATION", null);
        AnalysisToolPak.r(m2, "EDATE", null);
        AnalysisToolPak.r(m2, "EFFECT", null);
        AnalysisToolPak.r(m2, "EOMONTH", null);
        AnalysisToolPak.r(m2, "ERF", null);
        AnalysisToolPak.r(m2, "ERFC", null);
        AnalysisToolPak.r(m2, "FACTDOUBLE", null);
        AnalysisToolPak.r(m2, "FVSCHEDULE", null);
        AnalysisToolPak.r(m2, "GCD", null);
        AnalysisToolPak.r(m2, "GESTEP", null);
        AnalysisToolPak.r(m2, "HEX2BIN", null);
        AnalysisToolPak.r(m2, "HEX2DEC", null);
        AnalysisToolPak.r(m2, "HEX2OCT", null);
        AnalysisToolPak.r(m2, "IFERROR", null);
        AnalysisToolPak.r(m2, "IMABS", null);
        AnalysisToolPak.r(m2, "IMAGINARY", null);
        AnalysisToolPak.r(m2, "IMARGUMENT", null);
        AnalysisToolPak.r(m2, "IMCONJUGATE", null);
        AnalysisToolPak.r(m2, "IMCOS", null);
        AnalysisToolPak.r(m2, "IMDIV", null);
        AnalysisToolPak.r(m2, "IMEXP", null);
        AnalysisToolPak.r(m2, "IMLN", null);
        AnalysisToolPak.r(m2, "IMLOG10", null);
        AnalysisToolPak.r(m2, "IMLOG2", null);
        AnalysisToolPak.r(m2, "IMPOWER", null);
        AnalysisToolPak.r(m2, "IMPRODUCT", null);
        AnalysisToolPak.r(m2, "IMREAL", null);
        AnalysisToolPak.r(m2, "IMSIN", null);
        AnalysisToolPak.r(m2, "IMSQRT", null);
        AnalysisToolPak.r(m2, "IMSUB", null);
        AnalysisToolPak.r(m2, "IMSUM", null);
        AnalysisToolPak.r(m2, "INTRATE", null);
        AnalysisToolPak.r(m2, "ISEVEN", ParityFunction.IS_EVEN);
        AnalysisToolPak.r(m2, "ISODD", ParityFunction.IS_ODD);
        AnalysisToolPak.r(m2, "JIS", null);
        AnalysisToolPak.r(m2, "LCM", null);
        AnalysisToolPak.r(m2, "MDURATION", null);
        AnalysisToolPak.r(m2, "MROUND", MRound.instance);
        AnalysisToolPak.r(m2, "MULTINOMIAL", null);
        AnalysisToolPak.r(m2, "NETWORKDAYS", NetworkdaysFunction.instance);
        AnalysisToolPak.r(m2, "NOMINAL", null);
        AnalysisToolPak.r(m2, "OCT2BIN", null);
        AnalysisToolPak.r(m2, "OCT2DEC", null);
        AnalysisToolPak.r(m2, "OCT2HEX", null);
        AnalysisToolPak.r(m2, "ODDFPRICE", null);
        AnalysisToolPak.r(m2, "ODDFYIELD", null);
        AnalysisToolPak.r(m2, "ODDLPRICE", null);
        AnalysisToolPak.r(m2, "ODDLYIELD", null);
        AnalysisToolPak.r(m2, "PRICE", null);
        AnalysisToolPak.r(m2, "PRICEDISC", null);
        AnalysisToolPak.r(m2, "PRICEMAT", null);
        AnalysisToolPak.r(m2, "QUOTIENT", null);
        AnalysisToolPak.r(m2, "RANDBETWEEN", RandBetween.instance);
        AnalysisToolPak.r(m2, "RECEIVED", null);
        AnalysisToolPak.r(m2, "RTD", null);
        AnalysisToolPak.r(m2, "SERIESSUM", null);
        AnalysisToolPak.r(m2, "SQRTPI", null);
        AnalysisToolPak.r(m2, "SUMIFS", Sumifs.instance);
        AnalysisToolPak.r(m2, "TBILLEQ", null);
        AnalysisToolPak.r(m2, "TBILLPRICE", null);
        AnalysisToolPak.r(m2, "TBILLYIELD", null);
        AnalysisToolPak.r(m2, "WEEKNUM", null);
        AnalysisToolPak.r(m2, "WORKDAY", WorkdayFunction.instance);
        AnalysisToolPak.r(m2, "XIRR", null);
        AnalysisToolPak.r(m2, "XNPV", null);
        AnalysisToolPak.r(m2, "YEARFRAC", YearFrac.instance);
        AnalysisToolPak.r(m2, "YIELD", null);
        AnalysisToolPak.r(m2, "YIELDDISC", null);
        AnalysisToolPak.r(m2, "YIELDMAT", null);
        return m2;
    }

    private static void r(Map<String, FreeRefFunction> m2, String functionName, FreeRefFunction pFunc) {
        FreeRefFunction func = pFunc == null ? new NotImplemented(functionName) : pFunc;
        m2.put(functionName, func);
    }

    public static boolean isATPFunction(String name) {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        return inst._functionsByName.containsKey(name);
    }

    public static Collection<String> getSupportedFunctionNames() {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        TreeSet<String> lst = new TreeSet<String>();
        for (String name : inst._functionsByName.keySet()) {
            FreeRefFunction func = inst._functionsByName.get(name);
            if (func == null || func instanceof NotImplemented) continue;
            lst.add(name);
        }
        return Collections.unmodifiableCollection(lst);
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        TreeSet<String> lst = new TreeSet<String>();
        for (String name : inst._functionsByName.keySet()) {
            FreeRefFunction func = inst._functionsByName.get(name);
            if (func == null || !(func instanceof NotImplemented)) continue;
            lst.add(name);
        }
        return Collections.unmodifiableCollection(lst);
    }

    public static void registerFunction(String name, FreeRefFunction func) {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        if (!AnalysisToolPak.isATPFunction(name)) {
            FunctionMetadata metaData = FunctionMetadataRegistry.getFunctionByName(name);
            if (metaData != null) {
                throw new IllegalArgumentException(name + " is a built-in Excel function. " + "Use FunctoinEval.registerFunction(String name, Function func) instead.");
            }
            throw new IllegalArgumentException(name + " is not a function from the Excel Analysis Toolpack.");
        }
        FreeRefFunction f2 = inst.findFunction(name);
        if (f2 != null && !(f2 instanceof NotImplemented)) {
            throw new IllegalArgumentException("POI already implememts " + name + ". You cannot override POI's implementations of Excel functions");
        }
        inst._functionsByName.put(name, func);
    }

    private static final class NotImplemented
    implements FreeRefFunction {
        private final String _functionName;

        public NotImplemented(String functionName) {
            this._functionName = functionName;
        }

        public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
            throw new NotImplementedException(this._functionName);
        }
    }
}

