/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.groovy.ant.CompileTaskSupport;
import org.codehaus.groovy.tools.javac.JavaStubCompilationUnit;

public class GenerateStubsTask
extends CompileTaskSupport {
    protected void compile() {
        GroovyClassLoader gcl = this.createClassLoader();
        JavaStubCompilationUnit compilation = new JavaStubCompilationUnit(this.config, gcl, this.destdir);
        int count = 0;
        String[] list = this.src.list();
        for (int i2 = 0; i2 < list.length; ++i2) {
            File basedir = this.getProject().resolveFile(list[i2]);
            if (!basedir.exists()) {
                throw new BuildException("Source directory does not exist: " + basedir, this.getLocation());
            }
            DirectoryScanner scanner = this.getDirectoryScanner(basedir);
            String[] includes = scanner.getIncludedFiles();
            this.log.debug("Including files from: " + basedir);
            for (int j2 = 0; j2 < includes.length; ++j2) {
                this.log.debug("    " + includes[j2]);
                File file = new File(basedir, includes[j2]);
                compilation.addSourceFile(file);
                if (includes[j2].endsWith(".java")) continue;
                ++count;
            }
        }
        if (count > 0) {
            this.log.info("Generating " + count + " Java stub" + (count > 1 ? "s" : "") + " to " + this.destdir);
            compilation.compile(3);
        } else {
            this.log.info("No sources found for stub generation");
        }
    }
}

