/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import groovyjarjarantlr.ASTFactory;
import groovyjarjarantlr.CommonAST;
import groovyjarjarantlr.Token;
import groovyjarjarantlr.collections.AST;
import groovyjarjarantlr.debug.misc.ASTFrame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;

class Main {
    static boolean whitespaceIncluded = false;
    static boolean showTree = false;
    static boolean verbose = false;

    Main() {
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                System.err.println("Parsing...");
                for (int i2 = 0; i2 < args.length; ++i2) {
                    if (args[i2].equals("-showtree")) {
                        showTree = true;
                        continue;
                    }
                    if (args[i2].equals("-verbose")) {
                        verbose = true;
                        continue;
                    }
                    if (args[i2].equals("-trace")) {
                        GroovyRecognizer.tracing = true;
                        GroovyLexer.tracing = true;
                        continue;
                    }
                    if (args[i2].equals("-traceParser")) {
                        GroovyRecognizer.tracing = true;
                        continue;
                    }
                    if (args[i2].equals("-traceLexer")) {
                        GroovyLexer.tracing = true;
                        continue;
                    }
                    if (args[i2].equals("-whitespaceIncluded")) {
                        whitespaceIncluded = true;
                        continue;
                    }
                    Main.doFile(new File(args[i2]));
                }
            } else {
                System.err.println("Usage: java -jar groovyc.jar [-showtree] [-verbose] [-trace{,Lexer,Parser}]<directory or file name>");
            }
        }
        catch (Exception e2) {
            System.err.println("exception: " + e2);
            e2.printStackTrace(System.err);
        }
    }

    public static void doFile(File f2) throws Exception {
        if (f2.isDirectory()) {
            String[] files = f2.list();
            for (int i2 = 0; i2 < files.length; ++i2) {
                Main.doFile(new File(f2, files[i2]));
            }
        } else if (f2.getName().endsWith(".groovy")) {
            System.err.println(" --- " + f2.getAbsolutePath());
            SourceBuffer sourceBuffer = new SourceBuffer();
            UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(new FileReader(f2), sourceBuffer);
            GroovyLexer lexer = new GroovyLexer(unicodeReader);
            unicodeReader.setLexer(lexer);
            Main.parseFile(f2.getName(), lexer, sourceBuffer);
        }
    }

    public static void parseFile(String f2, GroovyLexer l2, SourceBuffer sourceBuffer) throws Exception {
        try {
            GroovyRecognizer parser = GroovyRecognizer.make(l2);
            parser.setSourceBuffer(sourceBuffer);
            parser.setFilename(f2);
            if (whitespaceIncluded) {
                Token t;
                GroovyLexer lexer = parser.getLexer();
                lexer.setWhitespaceIncluded(true);
                do {
                    t = lexer.nextToken();
                    System.out.println(t);
                } while (t != null && t.getType() != 1);
                return;
            }
            parser.compilationUnit();
            System.out.println("parseFile " + f2 + " => " + parser.getAST());
            Main.doTreeAction(f2, parser.getAST(), parser.getTokenNames());
        }
        catch (Exception e2) {
            System.err.println("parser exception: " + e2);
            e2.printStackTrace();
        }
    }

    public static void doTreeAction(String f2, AST t, String[] tokenNames) {
        if (t == null) {
            return;
        }
        if (showTree) {
            CommonAST.setVerboseStringConversion(true, tokenNames);
            ASTFactory factory = new ASTFactory();
            AST r = factory.create(0, "AST ROOT");
            r.setFirstChild(t);
            final ASTFrame frame = new ASTFrame("Groovy AST", r);
            frame.setVisible(true);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e2) {
                    frame.setVisible(false);
                    frame.dispose();
                    System.exit(0);
                }
            });
            if (verbose) {
                System.out.println(t.toStringList());
            }
        }
    }
}

