/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class ArrayExpression
extends Expression {
    private List expressions;
    private List sizeExpression;
    private ClassNode elementType;

    private static ClassNode makeArray(ClassNode base, List sizeExpression) {
        ClassNode ret = base.makeArray();
        if (sizeExpression == null) {
            return ret;
        }
        int size = sizeExpression.size();
        for (int i2 = 1; i2 < size; ++i2) {
            ret = ret.makeArray();
        }
        return ret;
    }

    public ArrayExpression(ClassNode elementType, List expressions, List sizeExpression) {
        Object item;
        super.setType(ArrayExpression.makeArray(elementType, sizeExpression));
        if (expressions == null) {
            expressions = Collections.EMPTY_LIST;
        }
        this.elementType = elementType;
        this.expressions = expressions;
        this.sizeExpression = sizeExpression;
        Iterator iter = expressions.iterator();
        while (iter.hasNext()) {
            item = iter.next();
            if (item == null || item instanceof Expression) continue;
            throw new ClassCastException("Item: " + item + " is not an Expression");
        }
        if (sizeExpression != null) {
            iter = sizeExpression.iterator();
            while (iter.hasNext()) {
                item = iter.next();
                if (item instanceof Expression) continue;
                throw new ClassCastException("Item: " + item + " is not an Expression");
            }
        }
    }

    public ArrayExpression(ClassNode elementType, List expressions) {
        this(elementType, expressions, null);
    }

    public void addExpression(Expression expression) {
        this.expressions.add(expression);
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitArrayExpression(this);
    }

    public boolean isDynamic() {
        return false;
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        List exprList = this.transformExpressions(this.expressions, transformer);
        List sizes = null;
        if (this.sizeExpression != null) {
            sizes = this.transformExpressions(this.sizeExpression, transformer);
        }
        ArrayExpression ret = new ArrayExpression(this.elementType, exprList, sizes);
        ret.setSourcePosition(this);
        return ret;
    }

    public Expression getExpression(int i2) {
        Object object = this.expressions.get(i2);
        return (Expression)object;
    }

    public ClassNode getElementType() {
        return this.elementType;
    }

    public String getText() {
        StringBuffer buffer = new StringBuffer("[");
        boolean first = true;
        Iterator iter = this.expressions.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(((Expression)iter.next()).getText());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public List getSizeExpression() {
        return this.sizeExpression;
    }

    public String toString() {
        return super.toString() + this.expressions;
    }
}

