/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.codehaus.groovy.reflection.ComplexKeyHashMap;

public class WeakDoubleKeyHashMap
extends ComplexKeyHashMap {
    private final ReferenceQueue queue = new ReferenceQueue();

    private void expungeStaleEntries() {
        Ref r;
        block0: while ((r = (Ref)this.queue.poll()) != null) {
            Entry prev;
            Entry e2 = r.entry;
            if (e2 == null) continue;
            r.entry = null;
            e2.key2 = null;
            e2.key1 = null;
            int h2 = e2.hash;
            int i2 = h2 & this.table.length - 1;
            Entry p = prev = (Entry)this.table[i2];
            while (p != null) {
                Entry next = (Entry)p.next;
                if (p == e2) {
                    if (prev == e2) {
                        this.table[i2] = next;
                    } else {
                        prev.next = next;
                    }
                    e2.next = null;
                    e2.value = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    public final Object get(Object key1, Object key2) {
        int h2 = WeakDoubleKeyHashMap.hash(31 * key1.hashCode() + key2.hashCode());
        ComplexKeyHashMap.Entry e2 = this.table[h2 & this.table.length - 1];
        while (e2 != null) {
            if (e2.hash == h2 && this.checkEquals((Entry)e2, key1, key2)) {
                return e2;
            }
            e2 = e2.next;
        }
        return null;
    }

    public boolean checkEquals(ComplexKeyHashMap.Entry e2, Object key1, Object key2) {
        Entry ee = (Entry)e2;
        return ee.key1.get() == key1 && ee.key2.get() == key2;
    }

    public Entry getOrPut(Object key1, Object key2) {
        ComplexKeyHashMap.Entry entry;
        int h2 = WeakDoubleKeyHashMap.hash(31 * key1.hashCode() + key2.hashCode());
        ComplexKeyHashMap.Entry[] t = this.table;
        int index = h2 & t.length - 1;
        ComplexKeyHashMap.Entry e2 = t[index];
        while (e2 != null) {
            if (e2.hash == h2 && this.checkEquals(e2, key1, key2)) {
                return (Entry)e2;
            }
            e2 = e2.next;
        }
        t[index] = entry = this.createEntry(key1, key2, h2, index);
        if (++this.size == this.threshold) {
            this.resize(2 * t.length);
        }
        return (Entry)entry;
    }

    private ComplexKeyHashMap.Entry createEntry(Object key1, Object key2, int h2, int index) {
        Entry entry = this.createEntry();
        entry.next = this.table[index];
        entry.hash = h2;
        entry.key1 = new Ref(key1, this.queue, entry);
        entry.key2 = new Ref(key2, this.queue, entry);
        return entry;
    }

    public Entry createEntry() {
        return new Entry();
    }

    public int size() {
        this.expungeStaleEntries();
        return super.size();
    }

    public final ComplexKeyHashMap.Entry remove(Object key1, Object key2) {
        this.expungeStaleEntries();
        int h2 = WeakDoubleKeyHashMap.hash(31 * key1.hashCode() + key2.hashCode());
        int index = h2 & this.table.length - 1;
        ComplexKeyHashMap.Entry e2 = this.table[index];
        ComplexKeyHashMap.Entry prev = null;
        while (e2 != null) {
            if (e2.hash == h2 && this.checkEquals((Entry)e2, key1, key2)) {
                if (prev == null) {
                    this.table[index] = e2.next;
                } else {
                    prev.next = e2.next;
                }
                --this.size;
                e2.next = null;
                return e2;
            }
            prev = e2;
            e2 = e2.next;
        }
        return null;
    }

    public static class Entry
    extends ComplexKeyHashMap.Entry {
        public Ref key1;
        public Ref key2;
    }

    private static class Ref
    extends WeakReference {
        Entry entry;

        public Ref(Object referent, ReferenceQueue q, Entry entry) {
            super(referent, q);
            this.entry = entry;
        }
    }
}

