/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.bytecode.ClassFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.javassist.FieldFilter;
import org.hibernate.bytecode.javassist.FieldTransformer;
import org.hibernate.bytecode.util.ClassFilter;

public class JavassistClassTransformer
extends AbstractClassTransformerImpl {
    private static Log log = LogFactory.getLog(JavassistClassTransformer.class.getName());
    static /* synthetic */ Class class$org$hibernate$bytecode$javassist$FieldHandled;

    public JavassistClassTransformer(ClassFilter classFilter, org.hibernate.bytecode.util.FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] doTransform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        byte[] byArray;
        ClassFile classfile;
        try {
            classfile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
        }
        catch (IOException e2) {
            log.error("Unable to build enhancement metamodel for " + className);
            return classfileBuffer;
        }
        FieldTransformer transformer = this.getFieldTransformer(classfile);
        if (transformer == null) return classfileBuffer;
        if (log.isDebugEnabled()) {
            log.debug("Enhancing " + className);
        }
        FilterOutputStream out = null;
        try {
            try {
                transformer.transform(classfile);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                out = new DataOutputStream(byteStream);
                classfile.write((DataOutputStream)out);
                byArray = byteStream.toByteArray();
                Object var12_13 = null;
            }
            catch (Exception e4) {
                log.error("Unable to transform class", e4);
                throw new HibernateException("Unable to transform class: " + e4.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException e3) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e3) {
            // empty catch block
            return byArray;
        }
        if (out == null) return byArray;
        out.close();
        return byArray;
    }

    protected FieldTransformer getFieldTransformer(final ClassFile classfile) {
        if (this.alreadyInstrumented(classfile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            public boolean handleRead(String desc, String name) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classfile.getName(), name);
            }

            public boolean handleWrite(String desc, String name) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classfile.getName(), name);
            }

            public boolean handleReadAccess(String fieldOwnerClassName, String fieldName) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classfile.getName(), fieldOwnerClassName, fieldName);
            }

            public boolean handleWriteAccess(String fieldOwnerClassName, String fieldName) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classfile.getName(), fieldOwnerClassName, fieldName);
            }
        });
    }

    private boolean alreadyInstrumented(ClassFile classfile) {
        String[] intfs = classfile.getInterfaces();
        for (int i2 = 0; i2 < intfs.length; ++i2) {
            if (!(class$org$hibernate$bytecode$javassist$FieldHandled == null ? JavassistClassTransformer.class$("org.hibernate.bytecode.javassist.FieldHandled") : class$org$hibernate$bytecode$javassist$FieldHandled).getName().equals(intfs[i2])) continue;
            return true;
        }
        return false;
    }
}

