/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.util;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.bytecode.util.ClassFilter;

public class BasicClassFilter
implements ClassFilter {
    private final String[] includedPackages;
    private final Set includedClassNames = new HashSet();
    private final boolean isAllEmpty;

    public BasicClassFilter() {
        this(null, null);
    }

    public BasicClassFilter(String[] includedPackages, String[] includedClassNames) {
        this.includedPackages = includedPackages;
        if (includedClassNames != null) {
            for (int i2 = 0; i2 < includedClassNames.length; ++i2) {
                this.includedClassNames.add(includedClassNames[i2]);
            }
        }
        this.isAllEmpty = (this.includedPackages == null || this.includedPackages.length == 0) && this.includedClassNames.isEmpty();
    }

    public boolean shouldInstrumentClass(String className) {
        if (this.isAllEmpty) {
            return true;
        }
        if (this.includedClassNames.contains(className)) {
            return true;
        }
        return this.isInIncludedPackage(className);
    }

    private boolean isInIncludedPackage(String className) {
        if (this.includedPackages != null) {
            for (int i2 = 0; i2 < this.includedPackages.length; ++i2) {
                if (!className.startsWith(this.includedPackages[i2])) continue;
                return true;
            }
        }
        return false;
    }
}

