/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.OptimisticCacheSource;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;

public class OptimisticTreeCache
implements OptimisticCache {
    private static final Log log = LogFactory.getLog(OptimisticTreeCache.class);
    private static final String ITEM = "item";
    private TreeCache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private OptimisticCacheSource source;

    public OptimisticTreeCache(TreeCache cache, String regionName) throws CacheException {
        this.cache = cache;
        this.regionName = regionName;
        this.regionFqn = Fqn.fromString((String)regionName.replace('.', '/'));
    }

    public void setSource(OptimisticCacheSource source) {
        this.source = source;
    }

    public void writeInsert(Object key, Object value, Object currentVersion) {
        this.writeUpdate(key, value, currentVersion, null);
    }

    public void writeUpdate(Object key, Object value, Object currentVersion, Object previousVersion) {
        try {
            Option option = new Option();
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, previousVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public void writeLoad(Object key, Object value, Object currentVersion) {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.remove(new Fqn(this.regionFqn, key), (Object)"ITEM", option);
            option = new Option();
            option.setFailSilently(true);
            DataVersion dv = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(currentVersion, currentVersion, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dv);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public Object get(Object key) throws CacheException {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            return this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM, option);
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public Object read(Object key) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM);
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public void update(Object key, Object value) throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            log.trace("performing put() into region [" + this.regionName + "]");
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.put(new Fqn(this.regionFqn, key), (Object)ITEM, value, option);
        }
        catch (TimeoutException te) {
            log.debug("ignoring write lock acquisition failure");
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            if (this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM) != null) {
                Option option = new Option();
                option.setDataVersion(NonLockingDataVersion.INSTANCE);
                this.cache.remove(new Fqn(this.regionFqn, key), option);
            } else {
                log.trace("skipping remove() call as the underlying node did not seem to exist");
            }
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public void clear() throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.remove(this.regionFqn, option);
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.remove(this.regionFqn, option);
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set children = this.cache.getChildrenNames(this.regionFqn);
            return children == null ? 0L : (long)children.size();
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = this.cache.getChildrenNames(this.regionFqn);
            if (childrenNames != null) {
                Iterator iter = childrenNames.iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    result.put(key, this.cache.get(new Fqn(this.regionFqn, key), (Object)ITEM));
                }
            }
            return result;
        }
        catch (Exception e2) {
            throw new CacheException(e2);
        }
    }

    public String toString() {
        return "OptimisticTreeCache(" + this.regionName + ')';
    }

    public static class CircumventChecksDataVersion
    implements DataVersion {
        public static final DataVersion INSTANCE = new CircumventChecksDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            throw new CacheException("optimistic locking checks should never happen on CircumventChecksDataVersion");
        }
    }

    public static class NonLockingDataVersion
    implements DataVersion {
        public static final DataVersion INSTANCE = new NonLockingDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            log.trace("non locking lock check...");
            return false;
        }
    }

    public static class DataVersionAdapter
    implements DataVersion {
        private final Object currentVersion;
        private final Object previousVersion;
        private final Comparator versionComparator;
        private final String sourceIdentifer;

        public DataVersionAdapter(Object currentVersion, Object previousVersion, Comparator versionComparator, String sourceIdentifer) {
            this.currentVersion = currentVersion;
            this.previousVersion = previousVersion;
            this.versionComparator = versionComparator;
            this.sourceIdentifer = sourceIdentifer;
            log.trace("created " + this);
        }

        public boolean newerThan(DataVersion dataVersion) {
            log.trace("checking [" + this + "] against [" + dataVersion + "]");
            if (dataVersion instanceof CircumventChecksDataVersion) {
                log.trace("skipping lock checks...");
                return false;
            }
            if (dataVersion instanceof NonLockingDataVersion) {
                log.trace("skipping lock checks...");
                return false;
            }
            DataVersionAdapter other = (DataVersionAdapter)dataVersion;
            if (other.previousVersion == null) {
                log.warn("Unexpected optimistic lock check on inserting data");
                if (this == dataVersion) {
                    log.trace("skipping lock checks due to same DV instance");
                    return false;
                }
            }
            return this.versionComparator.compare(this.currentVersion, other.previousVersion) >= 1;
        }

        public String toString() {
            return super.toString() + " [current=" + this.currentVersion + ", previous=" + this.previousVersion + ", src=" + this.sourceIdentifer + "]";
        }
    }
}

