/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentArrayHolder
extends AbstractPersistentCollection {
    protected Object array;
    private static final Log log = LogFactory.getLog(PersistentArrayHolder.class);
    private transient Class elementClass;
    private transient List tempList;

    public PersistentArrayHolder(SessionImplementor session, Object array) {
        super(session);
        this.array = array;
        this.setInitialized();
    }

    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        int length = Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(persister.getElementClass(), length);
        for (int i2 = 0; i2 < length; ++i2) {
            Object elt = Array.get(this.array, i2);
            try {
                Array.set(result, i2, persister.getElementType().deepCopy(elt, entityMode, persister.getFactory()));
                continue;
            }
            catch (IllegalArgumentException iae) {
                log.error("Array element type error", iae);
                throw new HibernateException("Array element type error", iae);
            }
        }
        return result;
    }

    public boolean isSnapshotEmpty(Serializable snapshot) {
        return Array.getLength(snapshot) == 0;
    }

    public Collection getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        int i2;
        Object[] sn = (Object[])snapshot;
        Object[] arr = (Object[])this.array;
        ArrayList<Object> result = new ArrayList<Object>();
        for (i2 = 0; i2 < sn.length; ++i2) {
            result.add(sn[i2]);
        }
        for (i2 = 0; i2 < sn.length; ++i2) {
            PersistentArrayHolder.identityRemove(result, arr[i2], entityName, this.getSession());
        }
        return result;
    }

    public PersistentArrayHolder(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        super(session);
        this.elementClass = persister.getElementClass();
    }

    public Object getArray() {
        return this.array;
    }

    public boolean isWrapper(Object collection) {
        return this.array == collection;
    }

    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        for (int i2 = 0; i2 < xlen; ++i2) {
            if (!elementType.isDirty(Array.get(snapshot, i2), Array.get(this.array, i2), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public Iterator elements() {
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            list.add(Array.get(this.array, i2));
        }
        return list.iterator();
    }

    public boolean empty() {
        return false;
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister, CollectionAliases descriptor, Object owner) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, owner, descriptor.getSuffixedElementAliases(), this.getSession());
        int index = (Integer)persister.readIndex(rs, descriptor.getSuffixedIndexAliases(), this.getSession());
        for (int i2 = this.tempList.size(); i2 <= index; ++i2) {
            this.tempList.add(i2, null);
        }
        this.tempList.set(index, element);
        return element;
    }

    public Iterator entries(CollectionPersister persister) {
        return this.elements();
    }

    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    public boolean endRead() {
        this.setInitialized();
        this.array = Array.newInstance(this.elementClass, this.tempList.size());
        for (int i2 = 0; i2 < this.tempList.size(); ++i2) {
            Array.set(this.array, i2, this.tempList.get(i2));
        }
        this.tempList = null;
        return true;
    }

    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Serializable[] cached = (Serializable[])disassembled;
        this.array = Array.newInstance(persister.getElementClass(), cached.length);
        for (int i2 = 0; i2 < cached.length; ++i2) {
            Array.set(this.array, i2, persister.getElementType().assemble(cached[i2], this.getSession(), owner));
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = Array.getLength(this.array);
        Serializable[] result = new Serializable[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result[i2] = persister.getElementType().disassemble(Array.get(this.array, i2), this.getSession(), null);
        }
        return result;
    }

    public Object getValue() {
        return this.array;
    }

    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        int end;
        int i2;
        int arraySize;
        ArrayList<Integer> deletes = new ArrayList<Integer>();
        Serializable sn = this.getSnapshot();
        int snSize = Array.getLength(sn);
        if (snSize > (arraySize = Array.getLength(this.array))) {
            for (i2 = arraySize; i2 < snSize; ++i2) {
                deletes.add(new Integer(i2));
            }
            end = arraySize;
        } else {
            end = snSize;
        }
        for (i2 = 0; i2 < end; ++i2) {
            if (Array.get(this.array, i2) != null || Array.get(sn, i2) == null) continue;
            deletes.add(new Integer(i2));
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i2, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return Array.get(this.array, i2) != null && (i2 >= Array.getLength(sn) || Array.get(sn, i2) == null);
    }

    public boolean needsUpdating(Object entry, int i2, Type elemType) throws HibernateException {
        Serializable sn = this.getSnapshot();
        return i2 < Array.getLength(sn) && Array.get(sn, i2) != null && Array.get(this.array, i2) != null && elemType.isDirty(Array.get(this.array, i2), Array.get(sn, i2), this.getSession());
    }

    public Object getIndex(Object entry, int i2, CollectionPersister persister) {
        return new Integer(i2);
    }

    public Object getElement(Object entry) {
        return entry;
    }

    public Object getSnapshotElement(Object entry, int i2) {
        Serializable sn = this.getSnapshot();
        return Array.get(sn, i2);
    }

    public boolean entryExists(Object entry, int i2) {
        return entry != null;
    }
}

