/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.List;
import org.dom4j.Element;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentIndexedElementHolder;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentListElementHolder
extends PersistentIndexedElementHolder {
    public PersistentListElementHolder(SessionImplementor session, Element element) {
        super(session, element);
    }

    public PersistentListElementHolder(SessionImplementor session, CollectionPersister persister, Serializable key) throws HibernateException {
        super(session, persister, key);
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Type elementType = persister.getElementType();
        String indexNodeName = PersistentListElementHolder.getIndexAttributeName(persister);
        Serializable[] cached = (Serializable[])disassembled;
        for (int i2 = 0; i2 < cached.length; ++i2) {
            Object object = elementType.assemble(cached[i2], this.getSession(), owner);
            Element subelement = this.element.addElement(persister.getElementNodeName());
            elementType.setToXMLNode(subelement, object, persister.getFactory());
            PersistentListElementHolder.setIndex(subelement, indexNodeName, Integer.toString(i2));
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        String indexNodeName = PersistentListElementHolder.getIndexAttributeName(persister);
        List elements = this.element.elements(persister.getElementNodeName());
        int length = elements.size();
        Serializable[] result = new Serializable[length];
        for (int i2 = 0; i2 < length; ++i2) {
            Element elem = (Element)elements.get(i2);
            Object object = elementType.fromXMLNode(elem, persister.getFactory());
            Integer index = (Integer)Hibernate.INTEGER.fromStringValue(PersistentListElementHolder.getIndex(elem, indexNodeName, i2));
            result[index.intValue()] = elementType.disassemble(object, this.getSession(), null);
        }
        return result;
    }
}

