/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.List;
import org.dom4j.Element;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentIndexedElementHolder;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;

public class PersistentMapElementHolder
extends PersistentIndexedElementHolder {
    public PersistentMapElementHolder(SessionImplementor session, Element element) {
        super(session, element);
    }

    public PersistentMapElementHolder(SessionImplementor session, CollectionPersister persister, Serializable key) throws HibernateException {
        super(session, persister, key);
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Type elementType = persister.getElementType();
        Type indexType = persister.getIndexType();
        String indexNodeName = PersistentMapElementHolder.getIndexAttributeName(persister);
        Serializable[] cached = (Serializable[])disassembled;
        int i2 = 0;
        while (i2 < cached.length) {
            Object index = indexType.assemble(cached[i2++], this.getSession(), owner);
            Object object = elementType.assemble(cached[i2++], this.getSession(), owner);
            Element subelement = this.element.addElement(persister.getElementNodeName());
            elementType.setToXMLNode(subelement, object, persister.getFactory());
            String indexString = ((NullableType)indexType).toXMLString(index, persister.getFactory());
            PersistentMapElementHolder.setIndex(subelement, indexNodeName, indexString);
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        Type indexType = persister.getIndexType();
        String indexNodeName = PersistentMapElementHolder.getIndexAttributeName(persister);
        List elements = this.element.elements(persister.getElementNodeName());
        int length = elements.size();
        Serializable[] result = new Serializable[length * 2];
        int i2 = 0;
        while (i2 < length * 2) {
            Element elem = (Element)elements.get(i2 / 2);
            Object object = elementType.fromXMLNode(elem, persister.getFactory());
            String indexString = PersistentMapElementHolder.getIndex(elem, indexNodeName, i2);
            Object index = ((NullableType)indexType).fromXMLString(indexString, persister.getFactory());
            result[i2++] = indexType.disassemble(index, this.getSession(), null);
            result[i2++] = elementType.disassemble(object, this.getSession(), null);
        }
        return result;
    }
}

