/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class IdentifierProjection
extends SimpleProjection {
    private boolean grouped;

    protected IdentifierProjection(boolean grouped) {
        this.grouped = grouped;
    }

    protected IdentifierProjection() {
        this(false);
    }

    public String toString() {
        return "id";
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new Type[]{criteriaQuery.getIdentifierType(criteria)};
    }

    public String toSqlString(Criteria criteria, int position, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer buf = new StringBuffer();
        String[] cols = criteriaQuery.getIdentifierColumns(criteria);
        for (int i2 = 0; i2 < cols.length; ++i2) {
            buf.append(cols[i2]).append(" as y").append(position + i2).append('_');
        }
        return buf.toString();
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        if (!this.grouped) {
            return super.toGroupSqlString(criteria, criteriaQuery);
        }
        return StringHelper.join(", ", criteriaQuery.getIdentifierColumns(criteria));
    }
}

